<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="<?php echo e(asset('images/CAMON.jpg')); ?>" type="image/jpg">
    <title>Balance Sheet - <?php echo e($reportData['title']); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @media print {
            body {
                font-size: 12px;
                background-color: white;
            }
            .no-print {
                display: none !important;
            }
            @page {
                size: A4;
                margin: 10mm;
            }
            .print-section {
                break-inside: avoid;
            }
            .summary-section {
                page-break-before: avoid;
                page-break-after: avoid;
                page-break-inside: avoid;
            }
        }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: #333;
        }
        .header-section {
            background-color: rgb(248, 191, 3);
            color: white;
            padding: 1.5rem;
            margin-bottom: 0;
            border-radius: 0.75rem 0.75rem 0 0;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            text-align: center;
            position: relative;
            display: flex; /* Tumia flexbox kwa mpangilio wa ndani */
            align-items: center; /* Sawazisha vitu katikati wima */
            justify-content: center; /* Sawazisha vitu katikati kwa usawa, itabadilishwa na logo */
            padding-left: 2rem; /* Nafasi ya kushoto kwa logo */
            padding-right: 2rem; /* Nafasi ya kulia kwa balance */
        }
        .header-section .logo {
            max-width: 100px; /* Rekebisha ukubwa wa logo inavyohitajika */
            height: auto;
            position: absolute; /* Weka logo kando */
            left: 2rem; /* Iweke kushoto kidogo */
            top: 50%; /* Iweke katikati wima */
            transform: translateY(-50%); /* Isawazishe kikamilifu katikati wima */
        }
        .header-content {
            flex-grow: 1; /* Ruhusu maudhui ya kichwa kujaza nafasi */
            text-align: center; /* Hakikisha maandishi yanakaa katikati */
        }
        .top-separator {
            background-color: rgb(245, 180, 3);
            height: 10px;
            margin-bottom: 1.5rem;
            border-radius: 0 0 0.75rem 0.75rem;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08);
        }
        .section-header {
            background-color: rgb(245, 180, 3);
            color: white;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem 0.5rem 0 0;
            font-weight: bold;
            font-size: 1.2rem;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08);
        }
        .asset-card {
            border: 1px solid #ddd;
            border-radius: 0.5rem;
            margin-bottom: 1.5rem;
            overflow: hidden;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            display: flex;
            flex-direction: column;
        }
        .card-body {
            padding: 1rem;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }
        .summary-card {
            background-color: #1f2937;
            color: white;
            border-radius: 0.75rem;
            padding: 2rem;
            margin-top: 2.5rem;
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
            display: flex;
            justify-content: space-between;
            align-items: center;
            flex-wrap: wrap;
        }
        .summary-card h3 {
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
            color: #ffeb3b;
        }
        .summary-card p {
            font-size: 2.5rem;
            font-weight: bold;
            color: #ffffff;
        }

        /* Table styling for better alignment */
        table {
            width: 100%;
            border-collapse: collapse; /* Crucial for straight borders */
            margin-bottom: 0.5rem; /* Small space below tables */
        }
        th, td {
            padding: 0.5rem 0.75rem; /* Adjusted padding for better alignment */
            border: none;
        }
        thead tr {
            border-bottom: 2px solid #ddd; /* Only bottom border for header row */
        }
        tbody tr {
            border-bottom: 1px solid #eee; /* Light bottom border for data rows */
        }
        th {
            background-color: #f3f4f6;
            font-weight: bold;
            color: #333;
            text-align: left;
        }
        th:last-child, td:last-child {
            text-align: right; /* Align amounts to the right */
        }

        .total-row {
            background-color: #dbeafe;
            font-weight: bold;
            border-top: 2px solid #99cfff; /* Top border for total rows */
            border-bottom: none;
        }
        .total-row td {
            border-top: none;
            border-bottom: none;
        }

        .grand-total-row {
            background-color: #bfdbfe;
            font-weight: bold;
            font-size: 1.1rem;
            border-top: 3px solid #7cbbed; /* Thicker top border for grand totals */
            border-bottom: none;
        }
        .grand-total-row td {
            border-top: none;
            border-bottom: none;
        }

        .balance-check {
            border-radius: 0.75rem;
            padding: 1.5rem;
            margin-top: 2rem;
            text-align: center;
            font-size: 1.1rem;
            font-weight: 600;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }
        .balanced {
            background-color: #dcfce7;
            color: #166534;
            border: 2px solid #166534;
        }
        .not-balanced {
            background-color: #fee2e2;
            color: #991b1b;
            border: 2px solid #991b1b;
        }

        /* Z-fill specific styles */
        .z-fill-row td {
            background-color: #f0f0f0;
            color: #ccc;
            text-align: center;
            font-family: monospace;
            border-bottom: 1px dashed #ddd;
            height: 28px;
            padding: 0.5rem;
            font-size: 0.9em;
        }
        .z-fill-row:last-of-type td {
            border-bottom: none;
        }

        /* Flexbox for column layout and stretching */
        .grid.grid-cols-1.md\:grid-cols-2 {
            display: flex;
            flex-wrap: wrap;
            align-items: stretch;
        }

        .grid.grid-cols-1.md\:grid-cols-2 > div {
            display: flex;
            flex-direction: column;
            flex: 1;
        }

        .asset-card {
            flex-grow: 1;
        }

        .card-body {
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }

        .card-body table {
            flex-shrink: 0;
        }
        .card-body tbody {
            flex-grow: 1;
        }

        /* Push total sections to the bottom of their respective card-bodies */
        .card-body tfoot {
            margin-top: auto;
        }
        .card-body > div:last-child {
            margin-top: auto;
        }
    </style>
</head>
<body>
    <div class="no-print flex justify-center gap-4 my-4">
        <button onclick="window.print()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md flex items-center shadow-md">
            <i class="fas fa-print mr-2"></i> Print Report
        </button>
        <button onclick="window.close()" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-md flex items-center shadow-md">
            <i class="fas fa-times mr-2"></i> Close
        </button>
    </div>

    <div class="container mx-auto px-4 py-6">
        <div class="header-section">
            <img src="<?php echo e(asset( 'images/CAMON.jpg')); ?>" alt="CAMON Enterprises Limited Logo" class="logo">
            <div class="header-content">
                <div class="company-name text-3xl font-bold mb-1">CAMON ENTERPRISES LIMITED</div>
                <h5 class="text-4xl font-extrabold mb-2">CAMON'S STATEMENT OF FINANCIAL POSITION</h5>
                <p class="text-xl">As of <span class="font-semibold"><?php echo e($reportData['reportDate']); ?></span></p>
                <p class="text-sm opacity-90 mt-2">Generated on: <?php echo e(now()->format('M d, Y H:i')); ?></p>
            </div>
        </div>
        <div class="top-separator"></div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div class="print-section">
                <div class="asset-card">
                    <div class="section-header">
                        <i class="fas fa-wallet mr-2"></i> ASSETS
                    </div>
                    <div class="card-body">
                        <h3 class="text-lg font-semibold mb-3 text-gray-700">Current Assets</h3>
                        <table id="current-assets-table">
                            <thead>
                                <tr class="table-header">
                                    <th class="text-left">Asset</th>
                                    <th class="text-right">Amount (TZS)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Inventory</td>
                                    <td><?php echo e(number_format($reportData['assets']['current']['inventory'], 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Cash</td>
                                    <td><?php echo e(number_format($reportData['assets']['current']['cash'], 2)); ?></td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="total-row">
                                    <td class="font-bold">Total Current Assets</td>
                                    <td class="text-right font-bold"><?php echo e(number_format($reportData['assets']['current']['total'], 2)); ?></td>
                                </tr>
                            </tfoot>
                        </table>

                        <h3 class="text-lg font-semibold mt-6 mb-3 text-gray-700">Non-Current Assets</h3>
                        <table id="non-current-assets-table">
                            <thead>
                                <tr class="table-header">
                                    <th class="text-left">Asset</th>
                                    <th class="text-right">Amount (TZS)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Property, Plant, & Equipment</td>
                                    <td><?php echo e(number_format($reportData['assets']['nonCurrent']['ppe'] ?? 0, 2)); ?></td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="total-row">
                                    <td class="font-bold">Total Non-Current Assets</td>
                                    <td class="text-right font-bold"><?php echo e(number_format($reportData['assets']['nonCurrent']['total'] ?? 0, 2)); ?></td>
                                </tr>
                            </tfoot>
                        </table>

                        <div class="mt-auto">
                            <h3 class="text-lg font-semibold mt-6 mb-3 text-gray-700">TOTAL ASSETS</h3>
                            <table>
                                <tbody>
                                    <tr class="grand-total-row">
                                        <td class="font-bold">TOTAL ASSETS</td>
                                        <td class="text-right font-bold"><?php echo e(number_format($reportData['assets']['current']['total'] + ($reportData['assets']['nonCurrent']['total'] ?? 0), 2)); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="print-section">
                <div class="asset-card">
                    <div class="section-header">
                        <i class="fas fa-file-invoice-dollar mr-2"></i> LIABILITIES & EQUITY
                    </div>
                    <div class="card-body">
                        <h3 class="text-lg font-semibold mb-3 text-gray-700">Current Liabilities</h3>
                        <table id="current-liabilities-table">
                            <thead>
                                <tr class="table-header">
                                    <th class="text-left">Liability</th>
                                    <th class="text-right">Amount (TZS)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Accounts Payable</td>
                                    <td><?php echo e(number_format($reportData['liabilities']['current']['accountsPayable'], 2)); ?></td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="total-row">
                                    <td class="font-bold">Total Current Liabilities</td>
                                    <td class="text-right font-bold"><?php echo e(number_format($reportData['liabilities']['current']['total'], 2)); ?></td>
                                </tr>
                            </tfoot>
                        </table>

                        <h3 class="text-lg font-semibold mt-6 mb-3 text-gray-700">Non-Current Liabilities</h3>
                        <table id="non-current-liabilities-table">
                            <thead>
                                <tr class="table-header">
                                    <th class="text-left">Liability</th>
                                    <th class="text-right">Amount (TZS)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Long-term Loans</td>
                                    <td><?php echo e(number_format($reportData['liabilities']['nonCurrent']['loans'], 2)); ?></td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="total-row">
                                    <td class="font-bold">Total Non-Current Liabilities</td>
                                    <td class="text-right font-bold"><?php echo e(number_format($reportData['liabilities']['nonCurrent']['total'], 2)); ?></td>
                                </tr>
                            </tfoot>
                        </table>

                        <h3 class="text-lg font-semibold mt-6 mb-3 text-gray-700">EQUITY</h3>
                        <table id="equity-table">
                            <thead>
                                <tr class="table-header">
                                    <th class="text-left">Equity Item</th>
                                    <th class="text-right">Amount (TZS)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Initial Capital</td>
                                    <td><?php echo e(number_format($reportData['equity']['capital'], 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Retained Earnings</td>
                                    <td><?php echo e(number_format($reportData['equity']['retainedEarnings'], 2)); ?></td>
                                </tr>
                                <tr>
                                    <td>Current Month's Profit</td>
                                    <td><?php echo e(number_format($reportData['equity']['currentProfit'], 2)); ?></td>
                                </tr>
                            </tbody>
                            <tfoot>
                                <tr class="total-row">
                                    <td class="font-bold">Total Equity</td>
                                    <td class="text-right font-bold"><?php echo e(number_format($reportData['equity']['totalEquity'], 2)); ?></td>
                                </tr>
                            </tfoot>
                        </table>

                        <div class="mt-auto">
                            <h3 class="text-lg font-semibold mt-6 mb-3 text-gray-700">TOTAL LIABILITIES & EQUITY</h3>
                            <table>
                                <tbody>
                                    <tr class="grand-total-row">
                                        <td class="font-bold">TOTAL LIABILITIES & EQUITY</td>
                                        <td class="text-right font-bold"><?php echo e(number_format($reportData['liabilities']['totalLiabilities'] + $reportData['equity']['totalEquity'], 2)); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        ---
        <div class="summary-section flex justify-between items-center bg-gray-900 text-white rounded-xl p-8 mt-10 shadow-xl flex-wrap">
            <div class="flex-1 text-center md:text-left mb-4 md:mb-0">
                <h3>GRAND TOTAL ASSETS</h3>
                <p><?php echo e(number_format($reportData['assets']['current']['total'] + ($reportData['assets']['nonCurrent']['total'] ?? 0), 2)); ?> TZS</p>
            </div>
            <div class="flex-1 text-center md:text-right">
                <h3>GRAND TOTAL LIABILITIES & EQUITY</h3>
                <p><?php echo e(number_format($reportData['liabilities']['totalLiabilities'] + $reportData['equity']['totalEquity'], 2)); ?> TZS</p>
            </div>
        </div>

        <?php
            $totalAssets = $reportData['assets']['current']['total'] + ($reportData['assets']['nonCurrent']['total'] ?? 0);
            $totalLiabilitiesAndEquity = $reportData['liabilities']['totalLiabilities'] + $reportData['equity']['totalEquity'];
            $isBalanced = (abs($totalAssets - $totalLiabilitiesAndEquity) < 0.01);
        ?>
        

        
        <div class="mt-8 text-center text-sm text-gray-600 no-print">
            <p>Generated by: <?php echo e(Auth::user()->name ?? 'System'); ?></p>
            <p>Generated on: <?php echo e(now()->format('d/m/Y H:i')); ?></p>
            <p class="mt-2">© <?php echo e(date('Y')); ?> Camon Enterprises Limited. All rights reserved.</p>
        </div>
    </div>

    <script>
        window.onload = function() {
            const printBtn = document.querySelector('.no-print button');
            if (printBtn) printBtn.focus();

            // Function to add Z-fill rows to a specific table's tbody
            function addZFillRows(tbody, numRows) {
                for (let i = 0; i < numRows; i++) {
                    const tr = document.createElement('tr');
                    tr.className = 'z-fill-row';
                    const td1 = document.createElement('td');
                    td1.className = 'p-2';
                    td1.textContent = 'Z';
                    const td2 = document.createElement('td');
                    td2.className = 'p-2 text-right';
                    td2.textContent = 'Z';
                    tr.appendChild(td1);
                    tr.appendChild(td2);
                    tbody.appendChild(tr);
                }
            }

            // Get all card-body elements
            const leftCardBody = document.querySelector('.grid > div:first-child .card-body');
            const rightCardBody = document.querySelector('.grid > div:last-child .card-body');

            // --- Step 1: Ensure initial alignment for Z-fill calculation ---
            let initialLeftHeight = leftCardBody.offsetHeight;
            let initialRightHeight = rightCardBody.offsetHeight;
            let maxHeight = Math.max(initialLeftHeight, initialRightHeight);

            leftCardBody.style.minHeight = maxHeight + 'px';
            rightCardBody.style.minHeight = maxHeight + 'px';

            // --- Step 2: Calculate and apply Z-fill based on *adjusted* heights ---
            const currentLeftHeight = leftCardBody.offsetHeight;
            const currentRightHeight = rightCardBody.offsetHeight;
            const targetHeight = Math.max(currentLeftHeight, currentRightHeight);
            const estimatedRowHeight = 28;

            function getLastContentTbody(cardBody) {
                const tables = cardBody.querySelectorAll('table');
                for (let i = tables.length - 1; i >= 0; i--) {
                    if (tables[i].querySelector('tbody') && !tables[i].querySelector('.grand-total-row')) {
                        return tables[i].querySelector('tbody');
                    }
                }
                return null;
            }

            if (currentLeftHeight < targetHeight) {
                const heightDifference = targetHeight - currentLeftHeight;
                const rowsToAdd = Math.ceil(heightDifference / estimatedRowHeight);
                const lastTbody = getLastContentTbody(leftCardBody);
                if (lastTbody) {
                    addZFillRows(lastTbody, rowsToAdd);
                }
            }

            if (currentRightHeight < targetHeight) {
                const heightDifference = targetHeight - currentRightHeight;
                const rowsToAdd = Math.ceil(heightDifference / estimatedRowHeight);
                const lastTbody = getLastContentTbody(rightCardBody);
                if (lastTbody) {
                    addZFillRows(lastTbody, rowsToAdd);
                }
            }

            // --- Step 3: Final Height Synchronization ---
            const finalLeftHeight = leftCardBody.offsetHeight;
            const finalRightHeight = rightCardBody.offsetHeight;
            const ultimateMaxHeight = Math.max(finalLeftHeight, finalRightHeight);

            leftCardBody.style.minHeight = ultimateMaxHeight + 'px';
            rightCardBody.style.minHeight = ultimateMaxHeight + 'px';
        };
    </script>
</body>
</html><?php /**PATH C:\Users\hp\managecamon\resources\views/reports/balance_sheet_pdf.blade.php ENDPATH**/ ?>