<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Monthly Comprehensive Financial Report')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h1 class="text-3xl font-bold mb-6 text-gray-800">Monthly Comprehensive Financial Report - <?php echo e($monthName); ?> <?php echo e($year); ?></h1>

                    <div class="bg-white shadow-md rounded-lg p-6 mb-8">
                        <h2 class="text-2xl font-semibold mb-4 text-indigo-700">Statement of Financial Position (Balance Sheet)</h2>
                        <p class="text-gray-600 mb-4">As of <?php echo e($balanceSheet['reportDate']); ?></p>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            
                            <div>
                                <h3 class="text-xl font-bold mb-3 text-gray-700">Assets</h3>
                                <div class="space-y-2">
                                    <p class="font-semibold text-lg text-gray-800 mb-2">Current Assets</p>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Cash Balance:</span>
                                        <span class="font-medium text-gray-900">$<?php echo e(number_format($balanceSheet['assets']['current']['cash'], 2)); ?></span>
                                    </div>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Inventory:</span>
                                        <span class="font-medium text-gray-900">$<?php echo e(number_format($balanceSheet['assets']['current']['inventory'], 2)); ?></span>
                                    </div>
                                    
                                    <div class="flex justify-between items-center font-bold border-t pt-2 text-md">
                                        <span>Total Current Assets:</span>
                                        <span>$<?php echo e(number_format($balanceSheet['assets']['current']['total'], 2)); ?></span>
                                    </div>

                                    <p class="font-semibold text-lg text-gray-800 mt-4 mb-2">Non-Current Assets</p>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Fixed Assets:</span>
                                        <span class="font-medium text-gray-900">$<?php echo e(number_format($balanceSheet['assets']['nonCurrent']['fixedAssets'], 2)); ?></span>
                                    </div>
                                    
                                    <div class="flex justify-between items-center font-bold border-t pt-2 text-md">
                                        <span>Total Non-Current Assets:</span>
                                        <span>$<?php echo e(number_format($balanceSheet['assets']['nonCurrent']['total'], 2)); ?></span>
                                    </div>

                                    <div class="flex justify-between items-center font-bold text-lg border-t-2 pt-4 text-green-700">
                                        <span>TOTAL ASSETS:</span>
                                        <span>$<?php echo e(number_format($balanceSheet['assets']['totalAssets'], 2)); ?></span>
                                    </div>
                                </div>
                            </div>

                            
                            <div>
                                <h3 class="text-xl font-bold mb-3 text-gray-700">Liabilities & Equity</h3>
                                <div class="space-y-2">
                                    <p class="font-semibold text-lg text-gray-800 mb-2">Liabilities</p>
                                    <p class="font-semibold text-md text-gray-700 mb-1">Current Liabilities</p>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Bank Overdraft:</span>
                                        <span class="font-medium text-gray-900">$<?php echo e(number_format($balanceSheet['liabilities']['current']['accountsPayable'], 2)); ?></span>
                                    </div>
                                    
                                    <div class="flex justify-between items-center font-bold border-t pt-2 text-md">
                                        <span>Total Current Liabilities:</span>
                                        <span>$<?php echo e(number_format($balanceSheet['liabilities']['current']['total'], 2)); ?></span>
                                    </div>

                                    <p class="font-semibold text-md text-gray-700 mt-4 mb-1">Non-Current Liabilities</p>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Loans Payable:</span>
                                        <span class="font-medium text-gray-900">$<?php echo e(number_format($balanceSheet['liabilities']['nonCurrent']['loans'], 2)); ?></span>
                                    </div>
                                    
                                    <div class="flex justify-between items-center font-bold border-t pt-2 text-md">
                                        <span>Total Non-Current Liabilities:</span>
                                        <span>$<?php echo e(number_format($balanceSheet['liabilities']['nonCurrent']['total'], 2)); ?></span>
                                    </div>

                                    <div class="flex justify-between items-center font-bold text-md border-t pt-2 text-gray-800">
                                        <span>TOTAL LIABILITIES:</span>
                                        <span>$<?php echo e(number_format($balanceSheet['liabilities']['totalLiabilities'], 2)); ?></span>
                                    </div>

                                    <p class="font-semibold text-lg text-gray-800 mt-4 mb-2">Equity</p>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Initial Capital:</span>
                                        <span class="font-medium text-gray-900">$<?php echo e(number_format($balanceSheet['equity']['capital'], 2)); ?></span>
                                    </div>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Retained Earnings:</span>
                                        <span class="font-medium text-gray-900">$<?php echo e(number_format($balanceSheet['equity']['retainedEarnings'], 2)); ?></span>
                                    </div>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Net Profit (Current Period):</span>
                                        <span class="font-medium text-gray-900">$<?php echo e(number_format($balanceSheet['equity']['currentProfit'], 2)); ?></span>
                                    </div>
                                    <div class="flex justify-between items-center font-bold border-t pt-2 text-md">
                                        <span>TOTAL EQUITY:</span>
                                        <span>$<?php echo e(number_format($balanceSheet['equity']['totalEquity'], 2)); ?></span>
                                    </div>

                                    <div class="flex justify-between items-center font-bold text-lg border-t-2 pt-4 text-green-700">
                                        <span>TOTAL LIABILITIES & EQUITY:</span>
                                        <span>$<?php echo e(number_format($balanceSheet['liabilities']['totalLiabilities'] + $balanceSheet['equity']['totalEquity'], 2)); ?></span>
                                    </div>

                                    <?php if(!$balanceSheet['isBalanced']): ?>
                                        <p class="text-red-600 font-bold mt-4">Warning: Balance Sheet is not balanced! Difference: $<?php echo e(number_format($balanceSheet['balanceCheck'], 2)); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    
                    
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH C:\Users\hp\managecamon\resources\views/reports/monthly-comprehensive.blade.php ENDPATH**/ ?>