<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="<?php echo e(asset('images/CAMON.jpg')); ?>" type="image/jpg">
    <title><?php echo e($title); ?> - <?php echo e($periodLabel); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @media print {
            body { 
                font-size: 12px;
                background-color: white;
            }
            .no-print { 
                display: none !important; 
            }
            @page { 
                size: A4;
                margin: 10mm;
            }
            .print-section {
                break-inside: avoid;
            }
            .summary-section {
                page-break-before: avoid;
                page-break-after: avoid;
                page-break-inside: avoid;
            }
        }
        body {
            font-family: Arial, sans-serif;
        }
        .header-section {
            background-color: rgb(250, 184, 2);
            color: white;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            border-radius: 0.5rem;
            display: flex; /* Tumia flexbox kwa mpangilio wa ndani */
            align-items: center; /* Sawazisha vitu katikati wima */
            justify-content: center; /* Sawazisha vitu katikati kwa usawa */
            position: relative; /* Kwa kuweka logo */
            padding-left: 6rem; /* Nafasi ya kushoto kwa logo */
            padding-right: 2rem; /* Nafasi ya kulia */
        }
        .header-section .logo {
            max-width: 100px; /* Rekebisha ukubwa wa logo inavyohitajika */
            height: auto;
            position: absolute; /* Weka logo kando */
            left: 2rem; /* Iweke kushoto kidogo */
            top: 50%; /* Iweke katikati wima */
            transform: translateY(-50%); /* Isawazishe kikamilifu katikati wima */
        }
        .header-content {
            flex-grow: 1; /* Ruhusu maudhui ya kichwa kujaza nafasi */
            text-align: center; /* Hakikisha maandishi yanakaa katikati */
        }
        .activity-header {
            background-color: rgb(250, 173, 5);
            color: white;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem 0.5rem 0 0;
            font-weight: bold;
            font-size: 1.1rem;
        }
        .activity-card {
            border: 1px solid #e5e7eb;
            border-radius: 0.5rem;
            margin-bottom: 1.5rem;
            overflow: hidden;
        }
        .activity-body {
            padding: 1rem;
        }
        .summary-card {
            background-color: #1f2937;
            color: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            margin-top: 1.5rem;
        }
        .negative-value {
            color: #ef4444;
        }
        .positive-value {
            color: #10b981;
        }
    </style>
</head>
<body>
    <div class="no-print flex justify-center gap-4 my-4">
        <button onclick="window.print()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md flex items-center">
            <i class="fas fa-print mr-2"></i> Print Report
        </button>
        <button onclick="window.close()" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-md flex items-center">
            <i class="fas fa-times mr-2"></i> Close
        </button>
    </div>

    <div class="container mx-auto px-4 py-6">
        <div class="header-section">
            <img src="<?php echo e(asset('images/CAMON.jpg')); ?>" alt="CAMON Enterprises Limited Logo" class="logo">
            <div class="header-content">
                <div class="company-name font-bold">CAMON ENTERPRISES LIMITED</div>
                <h5 class="text-2xl font-semibold mb-2">CAMON'S <?php echo e($title); ?></h5>
                <p class="text-lg"><?php echo e($periodLabel); ?></p>
                <p class="text-sm opacity-80 mt-1">Generated on: <?php echo e(now()->format('M d, Y H:i')); ?></p>
            </div>
        </div>

        <div class="activity-card print-section">
            <div class="activity-header">
                <i class="fas fa-exchange-alt mr-2"></i> Cash Flows from Operating Activities
            </div>
            <div class="activity-body">
                <table class="w-full">
                    <tbody>
                        <?php $__currentLoopData = [
                            'cashReceivedFromSales' => 'Cash Received from Sales',
                            'cashReceivedOtherIncome' => 'Cash Received from Other Income',
                            'cashReceivedFromPurchaseReturns' => 'Cash Received from Purchase Returns',
                            'cashPaidForStockPurchases' => 'Cash Paid for Stock Purchases', 
                            'cashPaidForExpenses' => 'Cash Paid for Expenses',
                            'cashPaidForSalaries' => 'Cash Paid for Salaries',
                            'cashPaidForSaleRefunds' => 'Cash Refunded for Sale Returns'
                        ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="border-b border-gray-100 hover:bg-gray-50">
                                <td class="py-2 px-2"><?php echo e($label); ?></td>
                                <td class="py-2 px-2 text-right <?php echo e(($reportData['operatingActivities'][$key] ?? 0) < 0 ? 'negative-value' : 'positive-value'); ?>">
                                    <?php if(($reportData['operatingActivities'][$key] ?? 0) < 0): ?>
                                        (TZS <?php echo e(number_format(abs($reportData['operatingActivities'][$key] ?? 0), 2)); ?>)
                                    <?php else: ?>
                                        TZS <?php echo e(number_format($reportData['operatingActivities'][$key] ?? 0, 2)); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr class="bg-indigo-50 font-bold">
                            <td class="py-3 px-2">Net Cash from Operating Activities</td>
                            <td class="py-3 px-2 text-right <?php echo e(($reportData['operatingActivities']['netCash'] ?? 0) < 0 ? 'negative-value' : 'positive-value'); ?>">
                                TZS <?php echo e(number_format($reportData['operatingActivities']['netCash'] ?? 0, 2)); ?>

                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="activity-card print-section">
            <div class="activity-header bg-blue-900">
                <i class="fas fa-chart-line mr-2"></i> Cash Flows from Investing Activities
            </div>
            <div class="activity-body">
                <table class="w-full">
                    <tbody>
                        <tr class="border-b border-gray-100 hover:bg-gray-50">
                            <td class="py-2 px-2">Net Cash from Investing Activities</td>
                            <td class="py-2 px-2 text-right <?php echo e(($reportData['investingActivities']['netCash'] ?? 0) < 0 ? 'negative-value' : 'positive-value'); ?>">
                                TZS <?php echo e(number_format($reportData['investingActivities']['netCash'] ?? 0, 2)); ?>

                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="activity-card print-section">
            <div class="activity-header bg-yellow-600">
                <i class="fas fa-hand-holding-usd mr-2"></i> Cash Flows from Financing Activities
            </div>
            <div class="activity-body">
                <table class="w-full">
                    <tbody>
                        <tr class="border-b border-gray-100 hover:bg-gray-50">
                            <td class="py-2 px-2">Net Cash from Financing Activities</td>
                            <td class="py-2 px-2 text-right <?php echo e(($reportData['financingActivities']['netCash'] ?? 0) < 0 ? 'negative-value' : 'positive-value'); ?>">
                                TZS <?php echo e(number_format($reportData['financingActivities']['netCash'] ?? 0, 2)); ?>

                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="summary-card summary-section">
            <h3 class="text-xl font-bold mb-4 text-center">Cash Flow Summary</h3>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <table class="w-full">
                        <tbody>
                            <tr>
                                <td class="py-1">Net Increase (Decrease) in Cash:</td>
                                <td class="py-1 text-right font-bold <?php echo e(($reportData['netIncreaseDecreaseInCash'] ?? 0) < 0 ? 'text-red-300' : 'text-green-300'); ?>">
                                    TZS <?php echo e(number_format($reportData['netIncreaseDecreaseInCash'] ?? 0, 2)); ?>

                                </td>
                            </tr>
                            <tr>
                                <td class="py-1">Cash at Beginning of Period:</td>
                                <td class="py-1 text-right">
                                    TZS <?php echo e(number_format($reportData['beginningCashBalance'] ?? 0, 2)); ?>

                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div>
                    <table class="w-full">
                        <tbody>
                            <tr>
                                <td class="py-1">Cash at End of Period:</td>
                                <td class="py-1 text-right font-bold text-blue-300">
                                    TZS <?php echo e(number_format($reportData['endingCashBalance'] ?? 0, 2)); ?>

                                </td>
                            </tr>
                            <tr>
                                <td class="py-1">Balance Check:</td>
                                <td class="py-1 text-right">
                                    <?php echo e(number_format(($reportData['reconciliationCheck'] ?? 0) - ($reportData['endingCashBalance'] ?? 0), 2)); ?>

                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

        </div>

        <div class="mt-8 text-center text-sm text-gray-600 no-print">
            <p>Generated by: <?php echo e(Auth::user()->name ?? 'System'); ?></p>
            <p>Generated on: <?php echo e(now()->format('d/m/Y H:i')); ?></p>
            <p class="mt-2">© <?php echo e(date('Y')); ?> Camon Enterprises Limited. All rights reserved.</p>
        </div>
    </div>

    <script>
        // Auto focus print button for better UX
        window.onload = function() {
            const printBtn = document.querySelector('.no-print button');
            if (printBtn) printBtn.focus();
        };
    </script>
</body>
</html><?php /**PATH C:\Users\hp\managecamon\resources\views/reports/cash_flow_statement_pdf.blade.php ENDPATH**/ ?>