<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Cash Flow Statement')); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12 bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen"> 
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-8 transform transition-all duration-300 hover:scale-[1.01] hover:shadow-2xl"> 

                <div class="flex justify-between items-center mb-6 pb-3 border-b border-gray-200"> 
                    <h3 class="text-3xl font-extrabold text-gray-900">Camon's Cash Flow Statement Report</h3> 
                    <p class="text-lg text-gray-600">For the period: <span class="font-bold text-blue-700"><?php echo e($periodLabel); ?></span></p> 
                </div>

                
                <div class="bg-white rounded-xl shadow-lg p-6 mb-8 border-t-4 border-blue-600"> 
                    <div class="flex justify-between items-center mb-4 pb-3 border-b border-gray-100">
                        <h4 class="text-xl font-bold text-gray-800 flex items-center">
                            <i class="fas fa-filter mr-3 text-blue-500"></i> 
                            Filter Report
                        </h4>
                    </div>
                    <form action="<?php echo e(route('reports.cash_flow')); ?>" method="GET">
                        <div class="grid grid-cols-1 md:grid-cols-4 gap-6 items-end"> 
                            <div class="col-span-1">
                                <label for="period" class="block text-sm font-medium text-gray-700 mb-1">Choose Period:</label>
                                <select name="period" id="period" class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm rounded-md shadow-sm">
                                    <option value="today" <?php echo e(request('period') == 'today' ? 'selected' : ''); ?>>Today</option>
                                    <option value="week" <?php echo e(request('period') == 'week' ? 'selected' : ''); ?>>This Week</option>
                                    <option value="month" <?php echo e(request('period', 'month') == 'month' ? 'selected' : ''); ?>>This Month</option>
                                    <option value="year" <?php echo e(request('period') == 'year' ? 'selected' : ''); ?>>This Year</option>
                                    <option value="custom" <?php echo e(request('period') == 'custom' ? 'selected' : ''); ?>>Customise Period</option>
                                </select>
                            </div>
                            <div class="col-span-1" id="startDateDiv"
                                style="<?php echo e(request('period') == 'custom' ? '' : 'display: none;'); ?>">
                                <label for="start_date" class="block text-sm font-medium text-gray-700 mb-1">Start Date:</label>
                                <input type="date" name="start_date" id="start_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                    value="<?php echo e(request('start_date')); ?>">
                            </div>
                            <div class="col-span-1" id="endDateDiv"
                                style="<?php echo e(request('period') == 'custom' ? '' : 'display: none;'); ?>">
                                <label for="end_date" class="block text-sm font-medium text-gray-700 mb-1">End Date:</label>
                                <input type="date" name="end_date" id="end_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500 sm:text-sm"
                                    value="<?php echo e(request('end_date')); ?>">
                            </div>
                            <div class="col-span-1 flex justify-end gap-3"> 
                                <button type="submit" class="inline-flex items-center px-6 py-2 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200" title="Bofya kuunda ripoti kulingana na vigezo ulivyochagua">
                                    <i class="fas fa-search mr-2"></i>
                                    Filter 
                                </button>
                                <a href="<?php echo e(route('reports.cash_flow.pdf', ['period' => request('period'), 'start_date' => request('start_date'), 'end_date' => request('end_date')])); ?>"
                                    class="inline-flex items-center px-6 py-2 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 transition-colors duration-200" target="_blank" title="Pakua ripoti hii kama PDF">
                                    <i class="fas fa-file-pdf mr-2"></i>
                                    Print PDF
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
                

                
                <div class="bg-white rounded-xl shadow-lg mb-8 border-t-4 border-indigo-600"> 
                    <div class="px-6 py-4 bg-indigo-600 text-white font-extrabold text-xl rounded-t-xl">Cash Flows from Operating Activities</div>
                    <div class="p-6">
                        <div class="overflow-x-auto"> 
                            <table class="min-w-full divide-y divide-gray-200">
                                <tbody class="bg-white divide-y divide-gray-200">
                                    <?php $__currentLoopData = [
                                        'cashReceivedFromSales' => 'Cash Received from Sales',
                                        'cashReceivedOtherIncome' => 'Cash Received from Other Income',
                                        'cashReceivedFromPurchaseReturns' => 'Cash Received from Purchase Returns',
                                        'cashPaidForStockPurchases' => 'Cash Paid for Stock Purchases', 
                                        'cashPaidForExpenses' => 'Cash Paid for Expenses',
                                        'cashPaidForSalaries' => 'Cash Paid for Salaries',
                                        'cashPaidForSaleRefunds' => 'Cash Refunded for Sale Returns' 
                                    ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr class="hover:bg-gray-50">
                                            <td class="px-6 py-3 whitespace-nowrap text-sm font-medium text-gray-900"><?php echo e($label); ?></td>
                                            <td class="px-6 py-3 whitespace-nowrap text-sm text-right <?php echo e(($reportData[$key] ?? 0) < 0 ? 'text-red-600' : 'text-green-600'); ?>">
                                                <?php if(($reportData[$key] ?? 0) < 0): ?>
                                                    (<?php echo e(number_format(abs($reportData[$key] ?? 0), 2)); ?>)
                                                <?php else: ?>
                                                    <?php echo e(number_format($reportData[$key] ?? 0, 2)); ?>

                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="bg-indigo-50 font-bold text-lg"> 
                                        <td class="px-6 py-3 whitespace-nowrap text-gray-900">Net Cash from Operating Activities</td>
                                        <td class="px-6 py-3 whitespace-nowrap text-right <?php echo e(($reportData['netCashFromOperatingActivities'] ?? 0) < 0 ? 'text-red-700' : 'text-green-700'); ?>">
                                            <?php echo e(number_format($reportData['netCashFromOperatingActivities'] ?? 0, 2)); ?>

                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                
                <div class="bg-white rounded-xl shadow-lg mb-8 border-t-4 border-green-600">
                    <div class="px-6 py-4 bg-green-600 text-white font-extrabold text-xl rounded-t-xl">Cash Flows from Investing Activities</div>
                    <div class="p-6">
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <tbody class="bg-white divide-y divide-gray-200">
                                    
                                    <tr class="bg-green-50 font-bold text-lg">
                                        <td class="px-6 py-3 whitespace-nowrap text-gray-900">Net Cash from Investing Activities</td>
                                        <td class="px-6 py-3 whitespace-nowrap text-right <?php echo e(($reportData['cashFromInvestingActivities'] ?? 0) < 0 ? 'text-red-700' : 'text-green-700'); ?>">
                                            <?php echo e(number_format($reportData['cashFromInvestingActivities'] ?? 0, 2)); ?>

                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                
                <div class="bg-white rounded-xl shadow-lg mb-8 border-t-4 border-yellow-600">
                    <div class="px-6 py-4 bg-yellow-600 text-white font-extrabold text-xl rounded-t-xl">Cash Flows from Financing Activities</div>
                    <div class="p-6">
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <tbody class="bg-white divide-y divide-gray-200">
                                    
                                    <tr class="bg-yellow-50 font-bold text-lg">
                                        <td class="px-6 py-3 whitespace-nowrap text-gray-900">Net Cash from Financing Activities</td>
                                        <td class="px-6 py-3 whitespace-nowrap text-right <?php echo e(($reportData['cashFromFinancingActivities'] ?? 0) < 0 ? 'text-red-700' : 'text-green-700'); ?>">
                                            <?php echo e(number_format($reportData['cashFromFinancingActivities'] ?? 0, 2)); ?>

                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

                
                <div class="bg-gray-800 rounded-xl shadow-2xl p-6 text-white border-t-4 border-gray-900"> 
                    <div class="mb-4 pb-4 border-b border-gray-700">
                        <h4 class="text-3xl font-extrabold text-white">Cash Flow Summary</h4>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full">
                            <tbody>
                                <tr class="font-bold text-xl">
                                    <td class="px-6 py-3 whitespace-nowrap">Net Increase (Decrease) in Cash</td>
                                    <td class="px-6 py-3 whitespace-nowrap text-right <?php echo e(($reportData['netIncreaseDecreaseInCash'] ?? 0) < 0 ? 'text-red-400' : 'text-green-400'); ?>">
                                        <?php echo e(number_format($reportData['netIncreaseDecreaseInCash'] ?? 0, 2)); ?>

                                    </td>
                                </tr>
                                <tr class="font-normal text-lg">
                                    <td class="px-6 py-3 whitespace-nowrap text-gray-300">Cash at Beginning of Period</td>
                                    <td class="px-6 py-3 whitespace-nowrap text-right text-gray-300"><?php echo e(number_format($reportData['beginningCashBalance'] ?? 0, 2)); ?></td>
                                </tr>
                                <tr class="font-extrabold text-3xl text-blue-300 border-t-2 border-b-2 border-blue-400 py-2">
                                    <td class="px-6 py-3 whitespace-nowrap">Cash at End of Period</td>
                                    <td class="px-6 py-3 whitespace-nowrap text-right"><?php echo e(number_format($reportData['endingCashBalance'] ?? 0, 2)); ?></td>
                                </tr>
                                
                                
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('period').addEventListener('change', function () {
            var period = this.value;
            if (period === 'custom') {
                document.getElementById('startDateDiv').style.display = 'block';
                document.getElementById('endDateDiv').style.display = 'block';
            } else {
                document.getElementById('startDateDiv').style.display = 'none';
                document.getElementById('endDateDiv').style.display = 'none';
            }
        });

        document.addEventListener('DOMContentLoaded', function() {
            var period = document.getElementById('period').value;
            if (period === 'custom') {
                document.getElementById('startDateDiv').style.display = 'block';
                document.getElementById('endDateDiv').style.display = 'block';
            }

            // If you are using Bootstrap's JavaScript for tooltips, ensure it's loaded.
            // Otherwise, you might need a custom tooltip implementation or a Tailwind CSS plugin.
            // For now, I'm commenting out the Bootstrap tooltip initialization as it won't work without it.
            /*
            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[title]'))
            var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });
            */
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?><?php /**PATH C:\Users\hp\managecamon\resources\views/reports/cash_flow_statement.blade.php ENDPATH**/ ?>