<!-- resources/views/reports/trial_balance.blade.php -->
<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            <?php echo e(__('Trial Balance')); ?> - As of: <?php echo e($trialBalanceData['reportDate']); ?>

        </h2>
     <?php $__env->endSlot(); ?>

    <div class="py-12 bg-gradient-to-br from-purple-50 to-pink-100 min-h-screen">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div
                class="bg-white overflow-hidden shadow-xl sm:rounded-lg p-8 transform transition-all duration-300 hover:scale-[1.01] hover:shadow-2xl">

                <div class="flex justify-between items-center mb-6 pb-3 border-b border-gray-200">
                    <h2 class="text-3xl font-extrabold text-gray-900 flex items-center">
                        <i class="fas fa-balance-scale-right mr-3 text-purple-600"></i> <?php echo e(__('Trial Balance Report')); ?>

                    </h2>
                    
                    <p class="text-lg text-gray-600">For the period: <span
                            class="font-bold text-purple-700"><?php echo e($trialBalanceData['reportDate']); ?></span></p>
                </div>

                
                <div class="bg-white rounded-xl shadow-lg p-6 mb-8 border-t-4 border-purple-600">
                    <div class="flex justify-between items-center mb-4 pb-3 border-b border-gray-100">
                        <h4 class="text-xl font-bold text-gray-800 flex items-center">
                            <i class="fas fa-calendar-alt mr-3 text-purple-500"></i> Select Report Date
                        </h4>
                    </div>
                    <form action="<?php echo e(route('reports.trial_balance')); ?>" method="GET">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 items-end">
                            <div class="col-span-1">
                                <label for="report_date" class="block text-sm font-medium text-gray-700 mb-1">Report
                                    Date:</label>
                                <input type="date" name="report_date" id="report_date"
                                    class="mt-1 block w-full pl-3 pr-10 py-2 text-base border-gray-300 focus:outline-none focus:ring-purple-500 focus:border-purple-500 sm:text-sm rounded-md shadow-sm"
                                    value="<?php echo e(request('report_date', \Carbon\Carbon::now()->format('Y-m-d'))); ?>">
                            </div>
                            <div class="col-span-2 flex justify-end gap-3">
                                <button type="submit"
                                    class="inline-flex items-center px-6 py-2 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-purple-600 hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500 transition-colors duration-200"
                                    title="Click to generate the report for the selected date">
                                    <i class="fas fa-search mr-2"></i>
                                    Generate Report
                                </button>
                                <a href="<?php echo e(route('reports.trial_balance.pdf', ['report_date' => request('report_date', \Carbon\Carbon::now()->format('Y-m-d'))])); ?>"
                                    class="inline-flex items-center px-6 py-2 border border-transparent text-base font-medium rounded-md shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500 transition-colors duration-200"
                                    target="_blank" title="Download this report as a PDF">
                                    <i class="fas fa-file-pdf mr-2"></i>
                                    Download PDF
                                </a>
                            </div>
                        </div>
                    </form>
                </div>

                
                <div class="bg-white rounded-xl shadow-lg border-t-4 border-gray-600">
                    <div class="px-6 py-4 bg-gray-600 text-white font-extrabold text-xl rounded-t-xl">
                        Account Balances
                    </div>
                    <div class="p-6">
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th scope="col"
                                            class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Account Name</th>
                                        <th scope="col"
                                            class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Debit (TZS)</th>
                                        <th scope="col"
                                            class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Credit (TZS)</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    
                                    <?php
                                        // Collect all unique account names from both debits and credits
                                        $allAccountNames = array_unique(array_merge(array_keys($trialBalanceData['accounts']['debits']), array_keys($trialBalanceData['accounts']['credits'])));
                                        sort($allAccountNames); // Optional: sort accounts alphabetically
                                    ?>

                                    <?php $__empty_1 = true; $__currentLoopData = $allAccountNames; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accountName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr class="hover:bg-gray-50">
                                            <td class="px-6 py-3 whitespace-nowrap text-sm font-medium text-gray-900">
                                                <?php echo e($accountName); ?>

                                            </td>
                                            <td class="px-6 py-3 whitespace-nowrap text-sm text-right text-green-600">
                                                <?php echo e(number_format($trialBalanceData['accounts']['debits'][$accountName] ?? 0, 2)); ?>

                                            </td>
                                            <td class="px-6 py-3 whitespace-nowrap text-sm text-right text-red-600">
                                                <?php echo e(number_format($trialBalanceData['accounts']['credits'][$accountName] ?? 0, 2)); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="3" class="px-6 py-4 text-center text-gray-500">No account balances found for the selected period.</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                                <tfoot class="bg-gray-100">
                                    <tr class="font-bold text-lg">
                                        <td class="px-6 py-4 whitespace-nowrap text-gray-900">Total</td>
                                        <td class="px-6 py-4 whitespace-nowrap text-right text-green-700">
                                            <?php echo e(number_format($trialBalanceData['totalDebits'], 2)); ?>

                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-right text-red-700">
                                            <?php echo e(number_format($trialBalanceData['totalCredits'], 2)); ?>

                                        </td>
                                    </tr>
                                    
                                    
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // No custom JavaScript needed for this specific Trial Balance report as the date input is always visible.
        // The dynamic date range selection logic from the Cash Flow report is not applicable here.
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\Users\hp\managecamon\resources\views/reports/trial_balance.blade.php ENDPATH**/ ?>