<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\StockOutputController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\SellerSalesController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\SalaryController;
use App\Http\Controllers\OtherIncomeController;
use App\Http\Controllers\NotificationController; 
use App\Http\Controllers\FixedAssetController; 
use App\Notifications\UserRegisteredNotification;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\PurchaseReturnController;
use App\Http\Controllers\SaleReturnController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

Route::get('/', function () {
    return view('welcome');
});

Route::middleware(['auth'])->group(function () {
    // Profile routes
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::get('auto-logout', [AuthenticatedSessionController::class, 'destroy'])
            ->name('auto.logout');

    //Notification routes
    Route::get('/notifications/{notification}', [NotificationController::class, 'show'])
         ->name('notifications.show');
    Route::get('/notifications', [NotificationController::class, 'index'])
         ->name('notifications.index');
    Route::patch('/notifications/{notification}/mark-as-read', [NotificationController::class, 'markAsRead'])
         ->name('notifications.markAsRead'); 
    Route::post('/notifications/mark-all-as-read', [NotificationController::class, 'markAllAsRead'])
         ->name('notifications.markAllAsRead');

    // Dashboard routes
    Route::get('/dashboard', function () {
        if (Auth::user()->role === 'admin') {
            return app(UserController::class)->adminDashboard();
        } elseif (Auth::user()->role === 'storekeeper') {
            return app(UserController::class)->storekeeperDashboard();
        } elseif (Auth::user()->role === 'seller') {
            return app(UserController::class)->sellerDashboard();
        }
        return view('welcome');
    })->name('dashboard');


    Route::middleware('auth')->group(function () {

    Route::get('/my-login-history', [UserController::class, 'showMyLoginHistory'])->name('user.login.history');
    Route::middleware('can:is-admin')->group(function () { // Using Gate for admin authorization
        Route::get('/admin/login-history', [UserController::class, 'showAllLoginHistory'])->name('admin.login.history');
    });
});

    // Stock overview route
    Route::get('/stock-overview', function () {
        return view('stock.overview', [
            'uniqueStockItemNames' => \App\Models\Product::distinct()->pluck('name')
        ]);
    })->name('stock.overview');

    Route::get('/sales-report/total', [SaleController::class, 'totalSales'])
    ->name('sales.total')
    ->middleware(['auth', 'can:is-admin']);

    Route::get('/products/overview', [ProductController::class, 'stockOverview'])
    ->name('products.overview')
    ->middleware(['auth', 'can:manage-stock']);

    // Role-specific dashboard routes
    Route::get('/admin/dashboard', [DashboardController::class, 'admin'])->name('admin.dashboard');
    Route::get('/storekeeper/dashboard', [DashboardController::class, 'storekeeper'])->name('storekeeper.dashboard');
    Route::get('/seller/dashboard', [DashboardController::class, 'seller'])->name('seller.dashboard');

    // Admin-specific routes
    Route::middleware(['can:is-admin'])->group(function () {
        // User Management
        Route::get('/admin/users', [UserController::class, 'index'])->name('users.index');
        Route::get('/admin/users/create/seller', [UserController::class, 'showSellerRegistrationForm'])->name('register.seller');
        Route::get('/admin/users/create/storekeeper', [UserController::class, 'showStorekeeperRegistrationForm'])->name('register.storekeeper');
        Route::post('/admin/users', [UserController::class, 'store'])->name('users.store');
        Route::get('/admin/users/{user}/edit', [UserController::class, 'edit'])->name('users.edit');
        Route::put('/admin/users/{user}', [UserController::class, 'update'])->name('users.update');
        Route::delete('/admin/users/{user}', [UserController::class, 'destroy'])->name('users.destroy');
        Route::get('/admin/users/sellers', [UserController::class, 'showSellers'])->name('users.sellers');
        Route::get('/admin/users/storekeepers', [UserController::class, 'showStorekeepers'])->name('users.storekeepers');
    });

    Route::get('/admin/users/{user}/details', [UserController::class, 'showUserDetails'])
    ->name('users.details')
    ->middleware(['auth', 'can:is-admin']);

    // Stock management routes (Admin & Storekeeper)
    Route::middleware(['can:manage-stock'])->group(function () {
        Route::resource('products', ProductController::class);
    });

    // Stock output/transfer routes (Admin & Storekeeper)
    Route::middleware(['can:manage-stock-output'])->group(function () {
        Route::resource('stock-outputs', StockOutputController::class);
    });

    // Admin-only report routes
Route::middleware(['auth', 'can:is-admin'])->group(function () {
    Route::get('/reports/stock-inputs', [ReportController::class, 'stockInputsReport'])->name('reports.stock-inputs');
    Route::get('/reports/stock-outputs', [ReportController::class, 'stockOutputsReport'])->name('reports.stock-outputs');
    Route::get('/reports/print/stock-inputs', [ReportController::class, 'printStockInputsReport'])->name('reports.print.stock-inputs');
    Route::get('/reports/print/stock-outputs', [ReportController::class, 'printStockOutputsReport'])->name('reports.print.stock-outputs');
});

     Route::middleware(['auth', 'can:is-admin'])->group(function () {
    // Ripoti ya mauzo na calendar
    Route::get('/sales/report', [SaleController::class, 'salesReportWithCalendar'])->name('sales.report');
    
    // Print ripoti
    Route::get('/sales/print', [SaleController::class, 'printReport'])->name('sales.print');
    
    // Funga mauzo ya mwezi
    Route::post('/sales/close-month', [SaleController::class, 'closeMonthlySales'])->name('sales.close-month');
    
    // Download monthly report
    Route::get('/sales/monthly-report/{id}', [SaleController::class, 'downloadMonthlyReport'])
        ->name('sales.download-monthly-report');
 
Route::get('/sales/download-pdf', [SaleController::class, 'downloadPdfReport'])->name('sales.download-pdf');
});

    Route::prefix('seller')->group(function() {
        Route::get('/sales', [SellerSalesController::class, 'index'])->name('seller.sales.index');
        Route::get('/stock', [SellerSalesController::class, 'availableStock'])->name('seller.stock');
    });

    Route::middleware(['can:sell-stock'])->group(function () {
        Route::resource('sales', SaleController::class)->except(['edit', 'update','delete']);
    });
    

    Route::prefix('seller')->group(function() {
    Route::get('/sales', [SellerSalesController::class, 'index'])->name('seller.sales.index');
    Route::get('/stock', [SellerSalesController::class, 'availableStock'])->name('seller.stock');
    Route::get('/received-stock', [SellerSalesController::class, 'receivedStock'])->name('seller.received-stock');
});

    Route::get('/products/transferred', [ProductController::class, 'transferred'])
        ->name('products.transferred')
        ->middleware('can:sell-stock');
});
    Route::middleware(['can:manage-all-stock-output'])->group(function () {
        Route::get('/admin/stock-outputs', [StockOutputController::class, 'adminIndex'])->name('admin.stock-outputs.index');
  });

    
    Route::resource('products', ProductController::class)->except(['show']);
    
    Route::get('/products/{product}', [ProductController::class, 'show'])
    ->name('products.show')
    ->middleware(['auth', 'can:manage-stock']);

    
    Route::middleware(['can:manage-stock'])->group(function () {
       Route::get('products/{product}/add-stock', [ProductController::class, 'showAddStockForm'])->name('products.add-stock.create');
       Route::post('products/{product}/add-stock', [ProductController::class, 'addStock'])->name('products.add-stock.store');
       Route::resource('purchase-returns', PurchaseReturnController::class);
       Route::resource('sale-returns', SaleReturnController::class);
});
    
    Route::get('/customers', [CustomerController::class, 'index'])
    ->name('customers.index')
    ->middleware(['auth', 'can:is-admin']);

     Route::resource('expenses', ExpenseController::class);
     Route::resource('salaries', SalaryController::class);
     Route::resource('other-incomes', OtherIncomeController::class);

Route::middleware(['auth', 'can:is-admin'])->group(function () {
    // Income Statement
    Route::get('/reports/income-statement', [ReportController::class, 'generateIncomeStatement'])->name('reports.income-statement');
    Route::get('/reports/income-statement/pdf', [ReportController::class, 'ViewIncomeStatementPdf'])->name('reports.income-statement.pdf');

    // Balance Sheet
    Route::get('/reports/balance-sheet', [ReportController::class, 'generateBalanceSheet'])->name('reports.balance-sheet');
    Route::get('/reports/balance-sheet/pdf', [ReportController::class, 'ViewBalanceSheetPdf'])->name('reports.balance-sheet.pdf');

    // Cashflow Statement
    Route::get('/reports/cash-flow-statement', [ReportController::class, 'generateCashflowStatement'])->name('reports.cash_flow');
    Route::get('/reports/cash-flow-statement/pdf', [ReportController::class, 'ViewCashflowStatementPdf'])->name('reports.cash_flow.pdf');

    // Trial Balance
    Route::get('/reports/trial-balance', [ReportController::class, 'generateTrialBalance'])->name('reports.trial_balance');
    Route::get('/reports/trial-balance/pdf', [ReportController::class, 'ViewTrialBalancePdf'])->name('reports.trial_balance.pdf');
        Route::get('/reports/trading-profit-loss-t-form', [ReportController::class, 'generateTradingProfitLossTForm'])->name('reports.trading-profit-loss-t-form');
    Route::get('/reports/trading-profit-loss-t-form/pdf', [ReportController::class, 'downloadTradingProfitLossTFormPdf'])->name('reports.trading-profit-loss-t-form.pdf');
});

    Route::middleware(['auth', 'can:is-admin'])->group(function () {
    Route::resource('fixed-assets', FixedAssetController::class);
    
});
// Add these to your web.php routes file
Route::middleware(['auth', 'can:is-admin'])->group(function () {
    
    // Individual reports
    Route::get('/reports/stock', [ReportController::class, 'stockReport'])->name('reports.stock-report');
});
Route::get('/reports/monthly', [ReportController::class, 'monthlyFinancialReport'])
    ->name('reports.monthly')
    ->middleware(['auth', 'can:is-admin']);
require __DIR__.'/auth.php';