<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule; // MUHIMU: Hii inahitajika
use App\Notifications\SalaryPaymentReminderNotification; // Import notification class
use App\Models\User; // Import User model
use Carbon\Carbon; // Import Carbon kwa ajili ya tarehe

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

Schedule::call(function () {
        $today = Carbon::now()->day;
        // Hakikisha ni kati ya tarehe 26 na 30 ya mwezi
        if ($today >= 26 && $today <= 30) {
            $admins = User::where('role', 'admin')->get();
            foreach ($admins as $admin) {
                $admin->notify(new SalaryPaymentReminderNotification());
            }
        }
    })->everyMinute() // Itakimbia kila siku saa 8 asubuhi
      ->name('salary_payment_reminder') // Jina la kipekee la task
      ->environments(['local']); 
