<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="{{ asset('images/CAMON.jpg') }}" type="image/jpg">
    <title>Camon Management System</title>

    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        @keyframes logo-float {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-1.25rem);
            }
        }

        .animate-logo-float {
            animation: logo-float 3s ease-in-out infinite;
        }
    </style>
</head>

<body class="bg-gray-50 dark:bg-gray-900 flex flex-col items-center min-h-screen p-6 space-y-8 pt-24 pb-28">

    <nav class="w-full fixed top-0 left-0 right-0 bg-yellow-500 py-5 shadow-lg z-50">
        <div class="container mx-auto px-4 flex justify-between items-center max-w-6xl relative">

            <img src="https://upload.wikimedia.org/wikipedia/commons/3/38/Flag_of_Tanzania.svg" alt="Tanzania Flag"
                class="h-10 w-auto rounded-sm shadow-md">

            <!-- System name centered using absolute positioning -->
            <div class="text-white font-bold text-2xl absolute left-1/2 -translate-x-1/2">CAMON MANAGEMENT SYSTEM</div>

            <!-- Auth/Login on the far right -->
            <div class="flex items-center space-x-6">
                @auth
                    <span class="text-white text-lg">Welcome, {{ Auth::user()->name }}</span>
                @else
                    <a href="{{ route('login') }}" class="text-white hover:text-gray-200 transition-colors text-lg">
                        Login
                    </a>
                @endauth
            </div>
        </div>
    </nav>

    <!-- Main Content Container -->
    <div class="flex flex-col items-center space-y-10 w-full max-w-4xl mx-auto mt-8">
        <!-- Centered First Logo -->
        <img src="{{ asset('images/CAMON.jpg') }}" alt="Camon Logo"
            class="w-40 h-40 animate-logo-float transition-transform duration-300 hover:scale-110">

        <!-- Centered System Name -->
        <h1 class="text-5xl font-bold text-center text-gray-800 dark:text-white animate-fade-in-up">
            Camon Management System
        </h1>

        <!-- Centered Conditional Button -->
        <div class="w-full flex justify-center mt-6">
            @auth
                @if(Auth::user()->role === 'admin')
                    <a href="{{ route('admin.dashboard') }}" class="px-10 py-4 text-xl font-semibold text-white bg-blue-600 rounded-lg 
                                      hover:bg-blue-700 transition-all duration-300 
                                      transform hover:scale-105 hover:shadow-lg
                                      motion-safe:animate-bounce">
                        Go to Dashboard
                    </a>
                @elseif(Auth::user()->role === 'seller')
                    <a href="{{ route('seller.dashboard') }}" class="px-10 py-4 text-xl font-semibold text-white bg-green-600 rounded-lg 
                                      hover:bg-green-700 transition-all duration-300 
                                      transform hover:scale-105 hover:shadow-lg
                                      motion-safe:animate-bounce">
                        Go to Dashboard
                    </a>
                @elseif(Auth::user()->role === 'storekeeper')
                    <a href="{{ route('storekeeper.dashboard') }}" class="px-10 py-4 text-xl font-semibold text-white bg-purple-600 rounded-lg 
                                      hover:bg-purple-700 transition-all duration-300 
                                      transform hover:scale-105 hover:shadow-lg
                                      motion-safe:animate-bounce">
                        Go to Dashboard
                    </a>
                @endif
            @else
                <a href="{{ route('login') }}" class="px-10 py-4 text-xl font-semibold text-white bg-blue-600 rounded-lg 
                              hover:bg-yellow-400 transition-all duration-300 
                              transform hover:scale-105 hover:shadow-lg
                              motion-safe:animate-bounce">
                    Login
                </a>
            @endauth
        </div>
    </div>

    <!-- Wider Black Footer -->
    <footer class="w-full fixed bottom-0 left-0 right-0 bg-black text-white py-5">
        <div class="container mx-auto px-4 text-center max-w-6xl">
            <p class="text-lg">&copy; {{ date('Y') }} Camon Management System. All rights reserved.</p>
        </div>
    </footer>
</body>

</html>