<x-app-layout>
    <x-slot name="header">
        <div class="bg-white dark:bg-gray-800 p-4 border-b border-gray-200 dark:border-gray-700">
            <div class="flex justify-between items-center">
                <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
                    {{ __('Storekeeper Dashboard') }}
                </h2>
                <div class="text-gray-800 dark:text-gray-200">
                    @auth
                        {{ __('Welcome, ') }}<span class="font-bold">{{ Auth::user()->name }}</span>
                    @endauth
                </div>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <div class="text-center mb-8">
                        <p class="text-2xl font-bold">{{ __("Welcome, Storekeeper!") }}</p>
                        <p class="text-gray-600 dark:text-gray-400 mt-2">{{ __("You can manage stock inputs and outputs.") }}</p>
                    </div>

                    <div class="flex flex-col md:flex-row gap-6"> {{-- Flex container for main content and sidebar --}}

                        {{-- Left Sidebar Area for Active Users (approx. 1/4 width on medium screens) --}}
                        <div class="md:w-1/4">
                            <div class="bg-blue-50 dark:bg-gray-700 p-6 rounded-lg shadow border-l-4 border-blue-400 h-full">
                                <div class="flex items-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-blue-600 dark:text-blue-400 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                    </svg>
                                    <h3 class="text-lg font-semibold text-blue-800 dark:text-blue-200">{{ __('Active Logged-In Users') }}</h3>
                                </div>
                                <p class="text-blue-700 dark:text-blue-300 mb-4 text-sm">{{ __('Users with recent activity:') }}</p>
                                <div class="max-h-80 overflow-y-auto border border-blue-200 dark:border-gray-600 rounded-md p-2">
                                    @if(isset($currentlyLoggedInUsers) && $currentlyLoggedInUsers->count() > 0)
                                        <ul class="list-disc list-inside text-gray-700 dark:text-gray-300 space-y-1">
                                            @foreach($currentlyLoggedInUsers as $user)
                                                <li>
                                                    <span class="font-medium">{{ $user->name }}</span> ({{ ucfirst($user->role) }})
                                                    @if ($user->id === Auth::id())
                                                        <span class="text-green-500 text-sm font-semibold">(You)</span>
                                                    @endif
                                                </li>
                                            @endforeach
                                        </ul>
                                    @else
                                        <p class="text-gray-500 dark:text-gray-400">{{ __('No other users currently active.') }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>

                        {{-- Right Main Content Area for Stock Management Links (approx. 3/4 width on medium screens) --}}
                        <div class="md:w-3/4">
                            <h3 class="text-lg font-semibold mb-4">{{ __('Stock Management Quick Links') }}</h3>

                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-2 xl:grid-cols-3 gap-6"> {{-- Adjusted grid for better fit with sidebar --}}
                                {{-- Quick links as before --}}
                                <div class="bg-blue-50 dark:bg-gray-700 p-6 rounded-lg shadow hover:shadow-md transition-shadow duration-300 border-l-4 border-blue-400">
                                    <div class="flex items-center mb-4">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-blue-600 dark:text-blue-400 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z" />
                                        </svg>
                                        <h3 class="text-lg font-semibold text-blue-800 dark:text-blue-200">View Current Stock</h3>
                                    </div>
                                    <p class="text-blue-700 dark:text-blue-300 mb-4">See the current inventory levels of all items.</p>
                                    <a href="{{ route('products.overview') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-md transition duration-300 transform hover:-translate-y-1">
                                        {{ __('View Stock') }}
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                        </svg>
                                    </a>
                                </div>

                                @can('manage-stock')
                                    <div class="bg-blue-50 dark:bg-gray-700 p-6 rounded-lg shadow hover:shadow-md transition-shadow duration-300 border-l-4 border-blue-400">
                                        <div class="flex items-center mb-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-blue-600 dark:text-blue-400 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4" />
                                            </svg>
                                            <h4 class="font-bold text-lg mb-1 text-blue-800 dark:text-blue-200">Manage Stock Inputs</h4>
                                        </div>
                                        <p class="text-blue-700 dark:text-blue-300 mb-4">Add new stock, view input history, or edit existing input records.</p>
                                        <a href="{{ route('products.index') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-md transition duration-300 transform hover:-translate-y-1">
                                            {{ __('Manage Inputs') }}
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                            </svg>
                                        </a>
                                    </div>
                                @endcan

                                @can('manage-stock-output')
                                    <div class="bg-blue-50 dark:bg-gray-700 p-6 rounded-lg shadow hover:shadow-md transition-shadow duration-300 border-l-4 border-blue-400">
                                        <div class="flex items-center mb-4">
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-blue-600 dark:text-blue-400 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                            </svg>
                                            <h4 class="font-bold text-lg mb-1 text-blue-800 dark:text-blue-200">Manage Stock Outputs</h4>
                                        </div>
                                        <p class="text-blue-700 dark:text-blue-300 mb-4">View sales history or record new product sales.</p>
                                        <a href="{{ route('stock-outputs.index') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded-md transition duration-300 transform hover:-translate-y-1">
                                            {{ __('Manage Outputs') }}
                                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                            </svg>
                                        </a>
                                    </div>
                                @endcan
                            </div>
                        </div>
                    </div> {{-- End flex container --}}
                </div>
            </div>
        </div>
    </div>
</x-app-layout>