<x-app-layout>
    <x-slot name="header">
        <div class="bg-white dark:bg-gray-800 p-4 border-b border-gray-200 dark:border-gray-700">
            <div class="flex justify-between items-center">
                <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
                    {{ __('Seller Dashboard') }}
                </h2>
                <div class="text-gray-800 dark:text-gray-200">
                    @auth
                        {{ __('Welcome, ') }}<span class="font-bold">{{ Auth::user()->name }}</span>
                    @endauth
                </div>
            </div>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <div class="text-center mb-8">
                        <p class="text-2xl font-bold">{{ __("Welcome, Seller!") }}</p>
                        <p class="text-gray-600 dark:text-gray-400 mt-2">{{ __("You can manage sales and view stock information.") }}</p>
                    </div>

                    <div class="flex flex-col md:flex-row gap-6">
                        {{-- Left Sidebar Area for Active Users (approx. 1/4 width on medium screens) --}}
                        <div class="md:w-1/4">
                            <div class="bg-green-50 dark:bg-gray-700 p-6 rounded-lg shadow border-l-4 border-green-400 h-full">
                                <div class="flex items-center mb-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-green-600 dark:text-green-400 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
                                    </svg>
                                    <h3 class="text-lg font-semibold text-green-800 dark:text-green-200">{{ __('Active Logged-In Users') }}</h3>
                                </div>
                                <p class="text-green-700 dark:text-green-300 mb-4 text-sm">{{ __('Users with recent activity:') }}</p>
                                <div class="max-h-80 overflow-y-auto border border-green-200 dark:border-gray-600 rounded-md p-2">
                                    @if(isset($currentlyLoggedInUsers) && $currentlyLoggedInUsers->count() > 0)
                                        <ul class="list-disc list-inside text-gray-700 dark:text-gray-300 space-y-1">
                                            @foreach($currentlyLoggedInUsers as $user)
                                                <li>
                                                    <span class="font-medium">{{ $user->name }}</span> ({{ ucfirst($user->role) }})
                                                    @if ($user->id === Auth::id())
                                                        <span class="text-green-500 text-sm font-semibold">(You)</span>
                                                    @endif
                                                </li>
                                            @endforeach
                                        </ul>
                                    @else
                                        <p class="text-gray-500 dark:text-gray-400">{{ __('No other users currently active.') }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>

                        {{-- Right Main Content Area for Sales & Stock Links (approx. 3/4 width on medium screens) --}}
                        <div class="md:w-3/4">
                            <h3 class="text-lg font-semibold mb-4">{{ __('Sales & Stock Information') }}</h3>
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div class="bg-green-50 dark:bg-gray-700 p-6 rounded-lg shadow hover:shadow-md transition-shadow duration-300 border-l-4 border-green-400">
                                    <div class="flex items-center mb-4">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-green-600 dark:text-green-400 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 4H6a2 2 0 00-2 2v12a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-2m-4-1v8m0 0l3-3m-3 3L9 8m-5 5h2.586a1 1 0 01.707.293l2.414 2.414a1 1 0 00.707.293h3.172a1 1 0 00.707-.293l2.414-2.414a1 1 0 01.707-.293H20" />
                                        </svg>
                                        <h3 class="text-lg font-semibold text-green-800 dark:text-green-200">View Received Stock</h3>
                                    </div>
                                    <p class="text-green-700 dark:text-green-300 mb-4">View stock you received.</p>
                                    <a href="{{ route('seller.received-stock') }}" class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-md transition duration-300 transform hover:-translate-y-1">
                                        {{ __('View Received Stock') }}
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                        </svg>
                                    </a>
                                </div> 
                                {{-- Sales Management Cards --}}
                                @can('sell-stock')
                                <div class="bg-green-50 dark:bg-gray-700 p-6 rounded-lg shadow hover:shadow-md transition-shadow duration-300 border-l-4 border-green-400">
                                    <div class="flex items-center mb-4">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-green-600 dark:text-green-400 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                        </svg>
                                        <h3 class="text-lg font-semibold text-green-800 dark:text-green-200">My Sales History</h3>
                                    </div>
                                    <p class="text-green-700 dark:text-green-300 mb-4">View Sales history.</p>
                                    <a href="{{ route('seller.sales.index') }}" class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-md transition duration-300 transform hover:-translate-y-1">
                                        {{ __('My sales history') }}
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                        </svg>
                                    </a>
                                </div>
                                @endcan
                                @can('sell-stock')
                                <div class="bg-green-50 dark:bg-gray-700 p-6 rounded-lg shadow hover:shadow-md transition-shadow duration-300 border-l-4 border-green-400">
                                    <div class="flex items-center mb-4">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-green-600 dark:text-green-400 mr-3" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z" />
                                        </svg>
                                        <h3 class="text-lg font-semibold text-green-800 dark:text-green-200">My Stock</h3>
                                    </div>
                                    <p class="text-green-700 dark:text-green-300 mb-4">My Stock.</p>
                                    <a href="{{ route('seller.stock') }}" class="inline-flex items-center px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded-md transition duration-300 transform hover:-translate-y-1">
                                        {{ __('My Stock') }}
                                        <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 ml-1" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 5l7 7m0 0l-7 7m7-7H3" />
                                        </svg>
                                    </a>
                                </div>
                                @endcan
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>