<!-- resources/views/sales/total.blade.php -->
<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Sales Report') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <!-- Period Filter -->
                    <div class="mb-6 bg-gray-100 dark:bg-gray-700 p-4 rounded-lg">
                        <form method="GET" action="{{ route('sales.total') }}" class="flex flex-wrap items-center gap-4">
                            <div>
                                <label for="period" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                    {{ __('Report Period') }}
                                </label>
                                <select name="period" id="period" class="rounded-md shadow-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                    <option value="today" {{ request('period') == 'today' ? 'selected' : '' }}>{{ __('Today') }}</option>
                                    <option value="week" {{ request('period') == 'week' ? 'selected' : '' }}>{{ __('This Week') }}</option>
                                    <option value="month" {{ request('period') == 'month' ? 'selected' : '' }}>{{ __('This Month') }}</option>
                                    <option value="year" {{ request('period') == 'year' ? 'selected' : '' }}>{{ __('This Year') }}</option>
                                    <option value="custom" {{ request('period') == 'custom' ? 'selected' : '' }}>{{ __('Custom Date Range') }}</option>
                                </select>
                            </div>

                            <div id="custom-date-range" class="{{ request('period') == 'custom' ? '' : 'hidden' }} flex items-center gap-4">
                                <div>
                                    <label for="start_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                        {{ __('Start Date') }}
                                    </label>
                                    <input type="date" name="start_date" id="start_date" value="{{ request('start_date') }}" class="rounded-md shadow-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                </div>
                                <div>
                                    <label for="end_date" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">
                                        {{ __('End Date') }}
                                    </label>
                                    <input type="date" name="end_date" id="end_date" value="{{ request('end_date') }}" class="rounded-md shadow-sm border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                </div>
                            </div>

                            <div class="mt-6">
                                <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2">
                                    {{ __('Filter') }}
                                </button>
                                <a href="{{ route('sales.print', ['start_date' => $startDate->format('Y-m-d'), 'end_date' => $endDate->format('Y-m-d')]) }}" 
   class="ml-2 px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2">
   {{ __('Print report') }}
</a>
                                <a href="{{ route('sales.total') }}" class="ml-2 px-4 py-2 bg-gray-600 text-white rounded-md hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-2">
                                    {{ __('Reset') }}
                                </a>
                            </div>
                        </form>
                    </div>

                    <!-- Summary Cards -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                        <div class="bg-blue-50 dark:bg-gray-700 p-6 rounded-lg shadow border-l-4 border-blue-400">
                            <h3 class="text-lg font-semibold text-blue-800 dark:text-blue-200 mb-2">{{ __('Total Sales Amount') }}</h3>
                            <p class="text-3xl font-bold text-blue-600 dark:text-blue-400">
                                {{ number_format($totalSales, 2) }}
                            </p>
                        </div>
                        <div class="bg-blue-50 dark:bg-gray-700 p-6 rounded-lg shadow border-l-4 border-blue-400">
                            <h3 class="text-lg font-semibold text-blue-800 dark:text-blue-200 mb-2">{{ __('Total Transactions') }}</h3>
                            <p class="text-3xl font-bold text-blue-600 dark:text-blue-400">
                                {{ number_format($totalTransactions) }}
                            </p>
                        </div>
                        <div class="bg-blue-50 dark:bg-gray-700 p-6 rounded-lg shadow border-l-4 border-blue-400">
                            <h3 class="text-lg font-semibold text-blue-800 dark:text-blue-200 mb-2">{{ __('Period') }}</h3>
                            <p class="text-xl font-bold text-blue-600 dark:text-blue-400">
                                {{ $periodLabel ?? 'Period not specified' }}
                            </p>
                        </div>
                    </div>

                    <!-- Sales Details Table -->
                    <div class="mb-8">
                        <h3 class="text-xl font-semibold mb-4">{{ __('Sales Details') }}</h3>
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                <thead class="bg-gray-50 dark:bg-gray-700">
                                    <tr>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Date') }}</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Customer') }}</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Product') }}</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Quantity') }}</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Selling Price/Unit') }}</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Total Selling Price') }}</th>
                                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">{{ __('Processed By') }}</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                    @forelse($sales as $sale)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ $sale->created_at->format('Y-m-d H:i') }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ $sale->customer->username ?? 'N/A' }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ $sale->product->name ?? 'N/A' }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ number_format($sale->quantity) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ number_format($sale->selling_price_per_unit, 2) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ number_format($sale->total_price, 2) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ $sale->soldBy->name ?? 'N/A' }}</td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="7" class="px-6 py-4 text-center">{{ __('No sales found for the selected period.') }}</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                                <tfoot class="bg-gray-100 dark:bg-gray-700 font-semibold">
                                    <tr>
                                        <td colspan="5" class="px-6 py-4 text-right">{{ __('Total:') }}</td>
                                        <td class="px-6 py-4">{{ number_format($totalSales, 2) }}</td>
                                        <td></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <!-- Pagination -->
                        @if($sales->hasPages())
                        <div class="mt-4">
                            {{ $sales->appends(request()->query())->links() }}
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Show/hide custom date range based on period selection
        document.getElementById('period').addEventListener('change', function() {
            const customDateRange = document.getElementById('custom-date-range');
            if (this.value === 'custom') {
                customDateRange.classList.remove('hidden');
            } else {
                customDateRange.classList.add('hidden');
            }
        });
    </script>
</x-app-layout>