<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('My Available Stock') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Stock Available for Sale</h3>
                        <div class="flex space-x-2">
                            <form method="GET" action="{{ route('seller.stock') }}" class="flex">
                                <input type="text" name="search" placeholder="Search my stock..." 
                                       value="{{ request('search') }}"
                                       class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm">
                                <button type="submit" class="ml-2 inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 focus:bg-gray-700 active:bg-gray-900 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 transition ease-in-out duration-150">
                                    Search
                                </button>
                            </form>
                            <a href="{{ route('seller.sales.index') }}" class="inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700 active:bg-blue-900 focus:outline-none focus:border-blue-900 focus:ring ring-blue-300 disabled:opacity-25 transition ease-in-out duration-150">
                                View My Sales
                            </a>
                        </div>
                    </div>

                    <div class="overflow-x-auto">
                       <table class="min-w-full divide-y divide-gray-200">
        <thead class="bg-gray-50">
            <tr>
                <th>Product</th>
                <th>Available</th>
                <th>Unit</th>
                <th>Price/Unit</th>
                <th>Total Value</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($products as $product)
                <tr>
                    <td>{{ $product->name }}</td>
                    <td>{{ number_format($product->available_quantity, 2) }}</td>
                    <td>{{ $product->unit }}</td>
                    <td>Tsh {{ number_format($product->selling_price_per_unit, 2) }}</td>
                    <td>Tsh {{ number_format($product->available_quantity * $product->selling_price_per_unit, 2) }}</td>
                    <td>
                        <a href="{{ route('sales.create', ['product_id' => $product->id]) }}" 
                           class="text-blue-600 hover:text-blue-900">
                            Sell
                        </a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6">No available stock found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>