<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('sales Report') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <!-- Calendar Picker -->
                    <form id="reportForm" method="GET" action="{{ route('sales.report') }}">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                            <div>
                                <x-input-label for="start_date" :value="__('Tarehe ya Kuanzia')" />
                                <x-text-input id="start_date" name="start_date" type="date" class="block w-full mt-1" 
                                    value="{{ request('start_date', now()->startOfMonth()->format('Y-m-d')) }}" required />
                            </div>
                            <div>
                                <x-input-label for="end_date" :value="__('Tarehe ya Mwisho')" />
                                <x-text-input id="end_date" name="end_date" type="date" class="block w-full mt-1" 
                                    value="{{ request('end_date', now()->endOfMonth()->format('Y-m-d')) }}" required />
                            </div>
                        </div>
                        
                        <div class="flex gap-4">
                            <x-primary-button type="submit">
                                {{ __('Search Sales/Time') }}
                            </x-primary-button>
                            
                            <x-secondary-button type="button" onclick="generateReport()">
                                {{ __('Print Report') }}
                            </x-secondary-button>
                            
                            @if(auth()->user()->isAdmin())
                            <x-danger-button type="button" onclick="closeMonthlySales()" class="ml-auto">
                                {{ __('Close Monthly Sales') }}
                            </x-danger-button>
                            @endif
                        </div>
                    </form>

                    <!-- Report Summary -->
                    @if(isset($sales) && $sales->count() > 0)
                    <div class="mt-8">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                            <div class="bg-blue-50 dark:bg-gray-700 p-4 rounded-lg">
                                <h3 class="font-semibold text-blue-800 dark:text-blue-200">Sales</h3>
                                <p class="text-2xl font-bold">{{ number_format($totalSales) }}</p>
                            </div>
                            <div class="bg-green-50 dark:bg-gray-700 p-4 rounded-lg">
                                <h3 class="font-semibold text-green-800 dark:text-green-200">Profit</h3>
                                <p class="text-2xl font-bold">{{ number_format($totalProfit) }}</p>
                            </div>
                            <div class="bg-purple-50 dark:bg-gray-700 p-4 rounded-lg">
                                <h3 class="font-semibold text-purple-800 dark:text-purple-200">Transaction</h3>
                                <p class="text-2xl font-bold">{{ $sales->count() }}</p>
                            </div>
                        </div>

                        <!-- Sales Table -->
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                <thead class="bg-gray-50 dark:bg-gray-700">
                                    <tr>
                                        <th class="px-6 py-3 text-left">Date</th>
                                        <th class="px-6 py-3 text-left">Customer</th>
                                        <th class="px-6 py-3 text-left">Stock Name</th>
                                        <th class="px-6 py-3 text-left">Quantity</th>
                                        <th class="px-6 py-3 text-left">Price</th>
                                        <th class="px-6 py-3 text-left">Total</th>
                                        <th class="px-6 py-3 text-left">Profit</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                    @foreach($sales as $sale)
                                    <tr>
                                        <td class="px-6 py-4">{{ $sale->created_at->format('d/m/Y H:i') }}</td>
                                        <td class="px-6 py-4">{{ $sale->customer->username }}</td>
                                        <td class="px-6 py-4">{{ $sale->product->name }}</td>
                                        <td class="px-6 py-4">{{ $sale->quantity }}</td>
                                        <td class="px-6 py-4">TZS {{ number_format($sale->selling_price_per_unit) }}</td>
                                        <td class="px-6 py-4">TZS {{ number_format($sale->total_price) }}</td>
                                        <td class="px-6 py-4">TZS {{ number_format(($sale->selling_price_per_unit - $sale->product->input_price_per_unit) * $sale->quantity) }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @else
                    <div class="mt-8 text-center py-12 bg-gray-50 dark:bg-gray-700 rounded-lg">
                        <p class="text-gray-500 dark:text-gray-400">No Sales done in this period.</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <script>
        function generateReport() {
            const form = document.getElementById('reportForm');
            const startDate = form.start_date.value;
            const endDate = form.end_date.value;
            
            window.open(`/sales/print?start_date=${startDate}&end_date=${endDate}`, '_blank');
        }
        
        function closeMonthlySales() {
            if(confirm('Una uhakika unataka kufunga mauzo ya mwezi huu?')) {
                fetch('/sales/close-month', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        month: new Date().getMonth() + 1,
                        year: new Date().getFullYear()
                    })
                })
                .then(response => response.json())
                .then(data => {
                    alert(data.message);
                    if(data.success) {
                        window.location.reload();
                    }
                });
            }
        }
    </script>
</x-app-layout>