<div class="overflow-x-auto">
    <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
        <thead class="bg-gray-50 dark:bg-gray-700">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Date</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Customer</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Stock</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Quantity</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Price/Unit</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Total Price</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">Profit</th>
            </tr>
        </thead>
        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
            @foreach($sales as $sale)
            <tr>
                <td class="px-6 py-4 whitespace-nowrap">{{ $sale->created_at->format('d/m/Y H:i') }}</td>
                <td class="px-6 py-4 whitespace-nowrap">{{ $sale->customer->username }}</td>
                <td class="px-6 py-4 whitespace-nowrap">{{ $sale->product->name }}</td>
                <td class="px-6 py-4 whitespace-nowrap">{{ $sale->quantity }}</td>
                <td class="px-6 py-4 whitespace-nowrap">{{ number_format($sale->selling_price_per_unit) }}</td>
                <td class="px-6 py-4 whitespace-nowrap">{{ number_format($sale->total_price) }}</td>
                <td class="px-6 py-4 whitespace-nowrap">
                    {{ number_format(($sale->selling_price_per_unit - $sale->product->input_price_per_unit) * $sale->quantity) }}
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>