<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Sales Report') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <!-- Chagua kipindi -->
                    <div class="mb-6 bg-blue-50 dark:bg-gray-700 p-4 rounded-lg">
                        <form id="periodForm" class="flex flex-wrap gap-4 items-center">
                            @csrf
                            <div>
                                <x-input-label for="period" :value="__('Chagua Kipindi:')" />
                                <select id="period" name="period" class="block mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50 dark:bg-gray-700 dark:text-white">
                                    <option value="day" {{ $period == 'day' ? 'selected' : '' }}>Today</option>
                                    <option value="week" {{ $period == 'week' ? 'selected' : '' }}>This Week</option>
                                    <option value="month" {{ $period == 'month' ? 'selected' : '' }}>This Month</option>
                                    <option value="quarter" {{ $period == 'quarter' ? 'selected' : '' }}>Quarter Year</option>
                                    <option value="half_year" {{ $period == 'half_year' ? 'selected' : '' }}>Half Year</option>
                                    <option value="year" {{ $period == 'year' ? 'selected' : '' }}>Year</option>
                                </select>
                            </div>
                            <div class="mt-6">
                                <x-primary-button type="button" onclick="printReport()">
                                    {{ __('Print Report') }}
                                </x-primary-button>
                            </div>
                        </form>
                    </div>

                    <!-- Onyesha taarifa za jumla -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div class="bg-green-50 dark:bg-gray-700 p-4 rounded-lg border-l-4 border-green-500">
                            <h3 class="text-lg font-semibold text-green-800 dark:text-green-300">Total Sales</h3>
                            <p class="text-2xl font-bold" id="totalSales">{{ number_format($totalSales) }}</p>
                        </div>
                        <div class="bg-blue-50 dark:bg-gray-700 p-4 rounded-lg border-l-4 border-blue-500">
                            <h3 class="text-lg font-semibold text-blue-800 dark:text-blue-300">Total Profit</h3>
                            <p class="text-2xl font-bold" id="totalProfit">{{ number_format($totalProfit) }}</p>
                        </div>
                    </div>

                    <!-- Orodha ya mauzo -->
                    <div id="reportContent">
                        @include('sales.report_partial')
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Badilisha kipindi bila kupakia upya ukurasa
        document.getElementById('period').addEventListener('change', function() {
            fetchReport(this.value);
        });

        function fetchReport(period) {
            const form = document.getElementById('periodForm');
            const formData = new FormData(form);
            
            fetch('{{ route("sales.report") }}', {
                method: 'POST',
                headers: {
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                document.getElementById('reportContent').innerHTML = data.html;
                document.getElementById('totalSales').textContent = data.totalSales;
                document.getElementById('totalProfit').textContent = data.totalProfit;
            });
        }

        function printReport() {
            const period = document.getElementById('period').value;
            window.open('{{ route("sales.print") }}?period=' + period, '_blank');
        }
    </script>
</x-app-layout>