<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ $title }} - Camon Management System</title>
    
    <!-- Load Tailwind CSS from CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <style>
        /* Common styles for both screen and print */
        body {
            font-family: Arial, sans-serif;
        }
        .print-header {
            display: flex;
            align-items: center;
            background-color: #f59e0b;
            color: white;
            padding: 1rem;
            margin-bottom: 1rem;
        }
        .print-logo {
            height: 50px;
            margin-right: 1rem;
        }
        .print-title {
            flex-grow: 1;
            text-align: center;
            font-weight: bold;
            font-size: 1.2rem;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            color: black;
        }
        .summary-box {
            margin-top: 1rem;
            padding: 1rem;
            background-color: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 0.25rem;
        }
        .footer {
            margin-top: 2rem;
            text-align: center;
            font-size: 0.8rem;
            color: #6c757d;
        }
        
        /* Screen-only styles */
        @media screen {
            body {
                background-color: #f3f4f6;
                padding: 1rem;
            }
            .print-container {
                background-color: white;
                padding: 2rem;
                max-width: 1000px;
                margin: 0 auto;
                box-shadow: 0 0 10px rgba(0,0,0,0.1);
            }
            .screen-actions {
                display: flex;
                justify-content: center;
                gap: 1rem;
                margin: 2rem 0;
            }
        }
        
        /* Print-only styles */
        @media print {
            body {
                background-color: white;
                font-size: 12px;
            }
            .screen-actions {
                display: none !important;
            }
            @page {
                size: A4;
                margin: 10mm;
            }
        }
    </style>
</head>

<body>
    <!-- Screen Actions - Visible only on screen -->
    <div class="screen-actions">
        <button onclick="window.print()" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
            Print Report
        </button>
        <button onclick="window.close()" class="bg-gray-500 hover:bg-gray-700 text-white font-bold py-2 px-4 rounded">
            Close
        </button>
    </div>

    <!-- Print Container -->
    <div class="print-container">
        <!-- Print Header -->
        <div class="print-header">
            <img src="{{ asset('images/CAMON.jpg') }}" alt="Camon Logo" class="print-logo">
            <div class="print-title">CAMON ENTERPRISES LIMITED</div>
        </div>

        <!-- Report Title -->
        <h1 class="text-xl font-bold text-center my-4">{{ $title }}</h1>
        <p class="text-center mb-4">From: {{ $startDate }} To: {{ $endDate }}</p>

        <!-- Sales Table -->
        <table>
            <thead>
                <tr>
                    <th>Date</th>
                    <th>Customer</th>
                    <th>Product</th>
                    <th>Qty</th>
                    <th>Price/Unit</th>
                    <th>Total</th>
                    <th>Sold By</th>
                </tr>
            </thead>
            <tbody>
                @foreach($sales as $sale)
                <tr>
                    <td>{{ $sale->created_at->format('d/m/Y H:i') }}</td>
                    <td>{{ $sale->customer->username }}</td>
                    <td>{{ $sale->product->name }}</td>
                    <td>{{ $sale->quantity }}</td>
                    <td>TZS {{ number_format($sale->selling_price_per_unit) }}</td>
                    <td>TZS {{ number_format($sale->total_price) }}</td>
                    <td>{{ $sale->soldBy->name }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <!-- Summary Section -->
        <div class="summary-box">
            <div class="flex justify-between">
                <span>Total Sales:</span>
                <strong>TZS {{ number_format($totalSales) }}</strong>
            </div>
            <div class="flex justify-between">
                <span>Total Profit:</span>
                <strong>TZS {{ number_format($totalProfit) }}</strong>
            </div>
            <div class="flex justify-between">
                <span>Transactions:</span>
                <strong>{{ $sales->count() }}</strong>
            </div>
        </div>

        <!-- Footer -->
        <div class="footer">
            <p>Generated by: {{ Auth::user()->name }}</p>
            <p>Generated on: {{ now()->format('d/m/Y H:i') }}</p>
            <p>&copy; {{ date('Y') }} Camon Management System</p>
        </div>
    </div>

    <script>
        // Auto-focus print button for better UX
        window.onload = function() {
            const printBtn = document.querySelector('.screen-actions button:first-child');
            if (printBtn) printBtn.focus();
        };
    </script>
</body>
</html>