<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Record New Sale') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    @if(session('error'))
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                            <strong class="font-bold">Error!</strong>
                            <span class="block sm:inline">{{ session('error') }}</span>
                        </div>
                    @endif

                    <form method="POST" action="{{ route('sales.store') }}">
                        @csrf

                        <div>
                            <x-input-label for="product_id" :value="__('Product to Sell')" />
<select id="product_id" name="product_id" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
    <option value="">Select Product</option>
    @foreach($products as $product)
        <option value="{{ $product->id }}" 
            data-selling-price="{{ $product->selling_price_per_unit }}" 
            data-current-quantity="{{ $product->quantity }}" 
            {{ old('product_id') == $product->id ? 'selected' : '' }}>
            {{ $product->name }} 
            (Tsh {{ number_format($product->selling_price_per_unit, 2) }} / {{ $product->unit }}) 
            - Available: {{ $product->quantity }}
        </option>
    @endforeach
</select>
                            <x-input-error :messages="$errors->get('product_id')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="quantity" :value="__('Quantity to Sell')" />
                            <x-text-input id="quantity" class="block mt-1 w-full" type="number" step="0.01" name="quantity" :value="old('quantity')" required />
                            <x-input-error :messages="$errors->get('quantity')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="display_selling_price" :value="__('Selling Price per Unit')" />
                            <x-text-input id="display_selling_price" class="block mt-1 w-full bg-gray-100" type="text" readonly />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="total_price" :value="__('Total Price')" />
                            <x-text-input id="total_price" class="block mt-1 w-full bg-gray-100" type="text" readonly />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="customer_username" :value="__('Customer Username')" />
                            <x-text-input id="customer_username" class="block mt-1 w-full" type="text" name="customer_username" :value="old('customer_username')" required />
                            <x-input-error :messages="$errors->get('customer_username')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="customer_phone_number" :value="__('Customer Phone Number (Optional)')" />
                            <x-text-input id="customer_phone_number" class="block mt-1 w-full" type="text" name="customer_phone_number" :value="old('customer_phone_number')" />
                            <x-input-error :messages="$errors->get('customer_phone_number')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button>
                                {{ __('Record Sale') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const productIdSelect = document.getElementById('product_id');
            const quantityInput = document.getElementById('quantity');
            const displaySellingPriceInput = document.getElementById('display_selling_price');
            const totalPriceInput = document.getElementById('total_price');

            function calculateTotalPrice() {
                const selectedOption = productIdSelect.options[productIdSelect.selectedIndex];
                const sellingPrice = parseFloat(selectedOption.dataset.sellingPrice);
                const quantity = parseFloat(quantityInput.value);

                if (!isNaN(sellingPrice) && !isNaN(quantity) && quantity > 0) {
                    const totalPrice = sellingPrice * quantity;
                    displaySellingPriceInput.value = `Tsh ${sellingPrice.toFixed(2)}`;
                    totalPriceInput.value = `Tsh ${totalPrice.toFixed(2)}`;
                } else {
                    displaySellingPriceInput.value = '';
                    totalPriceInput.value = '';
                }
            }

            productIdSelect.addEventListener('change', calculateTotalPrice);
            quantityInput.addEventListener('input', calculateTotalPrice);

            calculateTotalPrice();
        });
    </script>
    @endpush
</x-app-layout>