<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Record Sale Return') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <form method="POST" action="{{ route('sale-returns.store') }}">
                        @csrf

                        <div>
                            <x-input-label for="product_id" :value="__('Product')" />
                            <select id="product_id" name="product_id" class="block mt-1 w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                @foreach($products as $product)
                                    <option value="{{ $product->id }}">{{ $product->name }}</option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('product_id')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="quantity" :value="__('Quantity Returned')" />
                            <x-text-input id="quantity" class="block mt-1 w-full" type="number" name="quantity" :value="old('quantity')" required />
                            <x-input-error :messages="$errors->get('quantity')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="refund_amount" :value="__('Refund Amount (TZS)')" />
                            <x-text-input id="refund_amount" class="block mt-1 w-full" type="number" step="0.01" name="refund_amount" :value="old('refund_amount')" required />
                            <x-input-error :messages="$errors->get('refund_amount')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="return_date" :value="__('Return Date')" />
                            <x-text-input id="return_date" class="block mt-1 w-full" type="date" name="return_date" :value="old('return_date', now()->format('Y-m-d'))" required />
                            <x-input-error :messages="$errors->get('return_date')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="reason" :value="__('Reason for Return')" />
                            <x-text-area id="reason" class="block mt-1 w-full" name="reason">{{ old('reason') }}</x-text-area>
                            <x-input-error :messages="$errors->get('reason')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="sale_id" :value="__('Related Sale (Optional)')" />
                            <select id="sale_id" name="sale_id" class="block mt-1 w-full rounded-md shadow-sm border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <option value="">-- Select a Sale --</option>
                                @foreach($sales as $sale)
                                    <option value="{{ $sale->id }}">Sale #{{ $sale->id }} ({{ $sale->sale_date }}) - {{ $sale->total_price }}</option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('sale_id')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <x-primary-button>
                                {{ __('Record Return') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>