<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Description of Paying salary') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <div class="mb-4">
                        <p class="text-sm font-medium text-gray-700">Worker:</p>
                        <p class="mt-1 text-lg font-semibold">{{ $salary->user->name }} ({{ $salary->user->email }})</p>
                    </div>
                    <div class="mb-4">
                        <p class="text-sm font-medium text-gray-700">Amount:</p>
                        <p class="mt-1 text-lg font-semibold">{{ number_format($salary->amount, 2) }} TZS</p>
                    </div>
                    <div class="mb-4">
                        <p class="text-sm font-medium text-gray-700">Month of payment:</p>
                        <p class="mt-1 text-lg font-semibold">{{ \Carbon\Carbon::parse($salary->payment_month)->format('F Y') }}</p>
                    </div>
                    <div class="mb-4">
                        <p class="text-sm font-medium text-gray-700">Payment Date:</p>
                        <p class="mt-1 text-lg font-semibold">{{ \Carbon\Carbon::parse($salary->payment_date)->format('d M, Y') }}</p>
                    </div>
                    <div class="mb-4">
                        <p class="text-sm font-medium text-gray-700">Description:</p>
                        <p class="mt-1 text-lg font-semibold">{{ $salary->description ?? 'No Description' }}</p>
                    </div>
                    <div class="mt-6 flex items-center justify-start">
                        <a href="{{ route('salaries.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest hover:bg-gray-300 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150 mr-2">
                            Go back
                        </a>
                        @if(Auth::user()->role === 'admin')
                            <a href="{{ route('salaries.edit', $salary->id) }}" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:border-indigo-900 focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Edit
                            </a>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>