<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="{{ asset('images/CAMON.jpg') }}" type="image/jpg">
    <title>Trial Balance - {{ $trialBalanceData['reportDate'] }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @media print {
            body { 
                font-size: 12px;
                background-color: white;
            }
            .no-print { 
                display: none !important; 
            }
            @page { 
                size: A4;
                margin: 10mm;
            }
            .print-section {
                break-inside: avoid;
            }
            .summary-section {
                page-break-before: avoid;
                page-break-after: avoid;
                page-break-inside: avoid;
            }
        }
        body {
            font-family: Arial, sans-serif;
        }
        .header-section {
            background-color:rgb(255, 196, 0);
            color: white;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            border-radius: 0.5rem;
            display: flex; /* Tumia flexbox kwa mpangilio wa ndani */
            align-items: center; /* Sawazisha vitu katikati wima */
            justify-content: center; /* Sawazisha vitu katikati kwa usawa */
            position: relative; /* Kwa kuweka logo */
            padding-left: 6rem; /* Nafasi ya kushoto kwa logo */
            padding-right: 2rem; /* Nafasi ya kulia */
        }
        .header-section .logo {
            max-width: 100px; /* Rekebisha ukubwa wa logo inavyohitajika */
            height: auto;
            position: absolute; /* Weka logo kando */
            left: 2rem; /* Iweke kushoto kidogo */
            top: 50%; /* Iweke katikati wima */
            transform: translateY(-50%); /* Isawazishe kikamilifu katikati wima */
        }
        .header-content {
            flex-grow: 1; /* Ruhusu maudhui ya kichwa kujaza nafasi */
            text-align: center; /* Hakikisha maandishi yanakaa katikati */
        }
        .table-header {
            background-color: #f3f4f6;
            font-weight: bold;
        }
        .total-row {
            background-color: #e9d8fd;
            font-weight: bold;
        }
        .balance-status {
            border-radius: 0.5rem;
            padding: 1rem;
            margin-top: 1rem;
        }
        .balanced {
            background-color: #dcfce7;
            color: #166534;
        }
        .not-balanced {
            background-color: #fee2e2;
            color: #991b1b;
        }
        .debit {
            color: #10b981;
        }
        .credit {
            color: #ef4444;
        }
    </style>
</head>
<body>
    <div class="no-print flex justify-center gap-4 my-4">
        <button onclick="window.print()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md flex items-center">
            <i class="fas fa-print mr-2"></i> Print Report
        </button>
        <button onclick="window.close()" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-md flex items-center">
            <i class="fas fa-times mr-2"></i> Close
        </button>
    </div>

    <div class="container mx-auto px-4 py-6">
        <div class="header-section">
            <img src="{{ asset('images/CAMON.jpg') }}" alt="CAMON Enterprises Limited Logo" class="logo">
            <div class="header-content">
                <div class="company-name font-bold">CAMON ENTERPRISES LIMITED</div>
                <h5 class="text-2xl font-semibold mb-2">CAMON'S TRIAL BALANCE REPORT</h5>
                <p class="text-lg">As of {{ $trialBalanceData['reportDate'] }}</p>
                <p class="text-sm opacity-80 mt-1">Generated on: {{ now()->format('M d, Y H:i') }}</p>
            </div>
        </div>

        <div class="print-section">
            <div class="overflow-x-auto">
                <table class="min-w-full border-collapse">
                    <thead>
                        <tr class="table-header">
                            <th class="text-left p-2 border">Account Name</th>
                            <th class="text-right p-2 border">Debit (TZS)</th>
                            <th class="text-right p-2 border">Credit (TZS)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @php
                            $allAccountNames = array_unique(array_merge(
                                array_keys($trialBalanceData['accounts']['debits']), 
                                array_keys($trialBalanceData['accounts']['credits'])
                            ));
                            sort($allAccountNames);
                        @endphp

                        @forelse($allAccountNames as $accountName)
                            <tr class="border-b hover:bg-gray-50">
                                <td class="p-2 border">{{ $accountName }}</td>
                                <td class="p-2 border text-right debit">
                                    {{ number_format($trialBalanceData['accounts']['debits'][$accountName] ?? 0, 2) }}
                                </td>
                                <td class="p-2 border text-right credit">
                                    {{ number_format($trialBalanceData['accounts']['credits'][$accountName] ?? 0, 2) }}
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="3" class="p-2 border text-center text-gray-500">
                                    No account balances found for the selected period.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                    <tfoot>
                        <tr class="total-row">
                            <td class="p-2 border font-bold">Total</td>
                            <td class="p-2 border text-right font-bold debit">
                                {{ number_format($trialBalanceData['totalDebits'], 2) }}
                            </td>
                            <td class="p-2 border text-right font-bold credit">
                                {{ number_format($trialBalanceData['totalCredits'], 2) }}
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
            
        </div>

        <div class="mt-8 text-center text-sm text-gray-600 no-print">
            <p>Generated by: {{ Auth::user()->name ?? 'System' }}</p>
            <p>Generated on: {{ now()->format('d/m/Y H:i') }}</p>
            <p class="mt-2">© {{ date('Y') }} Camon Enterprises Limited. All rights reserved.</p>
        </div>
    </div>

    <script>
        // Auto focus print button for better UX
        window.onload = function() {
            const printBtn = document.querySelector('.no-print button');
            if (printBtn) printBtn.focus();
        };
    </script>
</body>
</html>