<!DOCTYPE html>
<html>
<head>
    <title>{{ $reportData['title'] }}</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; margin: 40px; }
        .header { text-align: center; margin-bottom: 30px; }
        .header h1 { font-size: 24px; margin-bottom: 5px; }
        .header p { font-size: 14px; color: #555; }
        .t-form-container {
            display: table; /* Use table display for PDF layout */
            width: 100%;
            border: 2px solid #333;
            border-collapse: collapse; /* Ensure borders collapse */
        }
        .t-form-row {
            display: table-row;
        }
        .t-form-half {
            display: table-cell;
            width: 50%; /* Divide width equally */
            padding: 15px;
            vertical-align: top; /* Align content to top */
        }
        .t-form-half:first-child {
            border-right: 2px solid #333;
        }
        .t-form-half h2 {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 15px;
            color: #4a4a4a;
        }
        .t-form-item {
            display: flex;
            justify-content: space-between;
            padding: 6px 0;
            border-bottom: 1px dotted #ccc;
            font-size: 12px;
        }
        .t-form-item:last-of-type {
            border-bottom: none;
        }
        .t-form-total-line {
            display: flex;
            justify-content: space-between;
            font-weight: bold;
            padding: 10px 0;
            margin-top: 15px;
            border-top: 2px solid #333;
            font-size: 14px;
        }
        .final-balance {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin-top: 30px;
            padding: 15px;
            border: 2px solid #2563eb;
            background-color: #eff6ff;
            border-radius: 8px; /* Note: border-radius might not be fully supported by all PDF renderers */
        }
        .profit { color: #16a34a; }
        .loss { color: #dc2626; }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $reportData['title'] }}</h1>
        <p>For the period: {{ $reportData['period'] }}</p>
    </div>

    <div class="t-form-container">
        <div class="t-form-row">
            <!-- Debit Side -->
            <div class="t-form-half">
                <h2>Debits</h2>
                <div class="content-items">
                    @foreach ($reportData['debitSide'] as $account => $amount)
                        <div class="t-form-item">
                            <span>{{ $account }}</span>
                            <span>{{ number_format($amount, 2) }} TZS</span>
                        </div>
                    @endforeach
                    @if ($reportData['netProfitLoss'] < 0)
                        <div class="t-form-item font-semibold loss" style="padding-top: 10px; border-bottom: none;">
                            <span>Net Loss (transferred to Capital)</span>
                            <span>{{ number_format(abs($reportData['netProfitLoss']), 2) }} TZS</span>
                        </div>
                    @endif
                </div>
                <div class="t-form-total-line">
                    <span>TOTAL DEBITS</span>
                    <span>
                        {{ number_format($reportData['totalDebits'] + ($reportData['netProfitLoss'] < 0 ? abs($reportData['netProfitLoss']) : 0), 2) }} TZS
                    </span>
                </div>
            </div>

            <!-- Credit Side -->
            <div class="t-form-half">
                <h2>Credits</h2>
                <div class="content-items">
                    @foreach ($reportData['creditSide'] as $account => $amount)
                        <div class="t-form-item">
                            <span>{{ $account }}</span>
                            <span>{{ number_format($amount, 2) }} TZS</span>
                        </div>
                    @endforeach
                    @if ($reportData['netProfitLoss'] >= 0)
                        <div class="t-form-item font-semibold profit" style="padding-top: 10px; border-bottom: none;">
                            <span>Net Profit (transferred to Capital)</span>
                            <span>{{ number_format($reportData['netProfitLoss'], 2) }} TZS</span>
                        </div>
                    @endif
                </div>
                <div class="t-form-total-line">
                    <span>TOTAL CREDITS</span>
                    <span>
                        {{ number_format($reportData['totalCredits'] + ($reportData['netProfitLoss'] >= 0 ? $reportData['netProfitLoss'] : 0), 2) }} TZS
                    </span>
                </div>
            </div>
        </div>
    </div>

    <div class="final-balance">
        @if ($reportData['netProfitLoss'] >= 0)
            <span class="profit">NET PROFIT: {{ number_format($reportData['netProfitLoss'], 2) }} TZS</span>
        @else
            <span class="loss">NET LOSS: {{ number_format(abs($reportData['netProfitLoss']), 2) }} TZS</span>
        @endif
    </div>
</body>
</html>
