<x-app-layout>
    {{-- Custom styles for the T-form layout --}}
    <style>
        .t-form-container {
            display: flex;
            border: 2px solid #333; /* Dark border for light mode */
            border-radius: 8px;
            overflow: hidden;
            background-color: #fff; /* White background for light mode */
        }
        .dark .t-form-container {
            border-color: #4b5563; /* Gray-700 for dark mode */
            background-color: #1f2937; /* Gray-800 for dark mode */
        }
        .t-form-half {
            flex: 1;
            padding: 20px;
            position: relative;
        }
        .t-form-half:first-child {
            border-right: 2px solid #333; /* Dark border for light mode */
        }
        .dark .t-form-half:first-child {
            border-right: 2px solid #4b5563; /* Gray-700 for dark mode */
        }
        .t-form-half h2 {
            text-align: center;
            font-size: 1.5rem;
            font-weight: bold;
            margin-bottom: 20px;
            color: #4a4a4a; /* Gray-700 for light mode */
        }
        .dark .t-form-half h2 {
            color: #d1d5db; /* Gray-300 for dark mode */
        }
        .t-form-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px dotted #ccc; /* Light dotted border for light mode */
        }
        .dark .t-form-item {
            border-bottom: 1px dotted #6b7280; /* Gray-500 for dark mode */
        }
        .t-form-item:last-of-type {
            border-bottom: none;
        }
        .t-form-total-line {
            display: flex;
            justify-content: space-between;
            font-weight: bold;
            padding: 10px 0;
            margin-top: 15px;
            border-top: 2px solid #333; /* Dark border for light mode */
            font-size: 1.125rem; /* text-lg */
        }
        .dark .t-form-total-line {
            border-top: 2px solid #4b5563; /* Gray-700 for dark mode */
        }
        .final-balance {
            text-align: center;
            font-size: 1.5rem;
            font-weight: bold;
            margin-top: 30px;
            padding: 15px;
            border: 2px solid #2563eb; /* blue-600 */
            background-color: #eff6ff; /* blue-50 */
            border-radius: 8px;
        }
        .dark .final-balance {
            border-color: #3b82f6; /* blue-500 for dark mode */
            background-color: #1e3a8a; /* blue-900 for dark mode */
        }
        .profit { color: #16a34a; /* green-600 */ }
        .dark .profit { color: #4ade80; /* green-400 for dark mode */ }
        .loss { color: #dc2626; /* red-600 */ }
        .dark .loss { color: #f87171; /* red-400 for dark mode */ }
    </style>

    <x-slot name="header">
        {{-- The header slot for x-app-layout. The report title will appear here. --}}
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ $reportData['title'] }}
        </h2>
    </x-slot>

    {{-- Main content area for the Trading, Profit & Loss (T-Form) report. --}}
    {{-- This div now takes the place of the old body content, styled for centering and responsiveness. --}}
    <div class="py-12">
        <div class="max-w-5xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg p-8">
                <p class="text-gray-600 dark:text-gray-400 text-center mb-8 text-sm">For the period: <span class="font-semibold">{{ $reportData['period'] }}</span></p>

                <div class="t-form-container">
                    <!-- Debit Side -->
                    <div class="t-form-half">
                        <h2>Debits</h2>
                        <div class="space-y-2">
                            @foreach ($reportData['debitSide'] as $account => $amount)
                                <div class="t-form-item">
                                    <span class="text-gray-900 dark:text-gray-100">{{ $account }}</span>
                                    <span class="text-gray-900 dark:text-gray-100">{{ number_format($amount, 2) }} TZS</span>
                                </div>
                            @endforeach
                            @if ($reportData['netProfitLoss'] < 0)
                                <div class="t-form-item font-semibold text-red-600 dark:text-red-400 pt-4">
                                    <span>Net Loss (transferred to Capital)</span>
                                    <span>{{ number_format(abs($reportData['netProfitLoss']), 2) }} TZS</span>
                                </div>
                            @endif
                        </div>
                        <div class="t-form-total-line text-gray-900 dark:text-gray-100">
                            <span>TOTAL DEBITS</span>
                            <span>
                                {{ number_format($reportData['totalDebits'] + ($reportData['netProfitLoss'] < 0 ? abs($reportData['netProfitLoss']) : 0), 2) }} TZS
                            </span>
                        </div>
                    </div>

                    <!-- Credit Side -->
                    <div class="t-form-half">
                        <h2>Credits</h2>
                        <div class="space-y-2">
                            @foreach ($reportData['creditSide'] as $account => $amount)
                                <div class="t-form-item">
                                    <span class="text-gray-900 dark:text-gray-100">{{ $account }}</span>
                                    <span class="text-gray-900 dark:text-gray-100">{{ number_format($amount, 2) }} TZS</span>
                                </div>
                            @endforeach
                            @if ($reportData['netProfitLoss'] >= 0)
                                <div class="t-form-item font-semibold text-green-600 dark:text-green-400 pt-4">
                                    <span>Net Profit (transferred to Capital)</span>
                                    <span>{{ number_format($reportData['netProfitLoss'], 2) }} TZS</span>
                                </div>
                            @endif
                        </div>
                        <div class="t-form-total-line text-gray-900 dark:text-gray-100">
                            <span>TOTAL CREDITS</span>
                            <span>
                                {{ number_format($reportData['totalCredits'] + ($reportData['netProfitLoss'] >= 0 ? $reportData['netProfitLoss'] : 0), 2) }} TZS
                            </span>
                        </div>
                    </div>
                </div>

                <div class="final-balance">
                    @if ($reportData['netProfitLoss'] >= 0)
                        <span class="profit">NET PROFIT: {{ number_format($reportData['netProfitLoss'], 2) }} TZS</span>
                    @else
                        <span class="loss">NET LOSS: {{ number_format(abs($reportData['netProfitLoss']), 2) }} TZS</span>
                    @endif
                </div>

                <div class="mt-10 text-center">
                    <a href="{{ route('reports.trading-profit-loss-t-form.pdf', ['start_date' => $startDate->format('Y-m-d'), 'end_date' => $endDate->format('Y-m-d')]) }}" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-3 px-6 rounded-lg shadow-md transition duration-300 ease-in-out">
                        Download PDF Report
                    </a>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
