<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Stock Outputs Report') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <!-- Date Filter -->
                    <form method="GET" action="{{ route('reports.stock-outputs') }}" class="mb-6">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <x-input-label for="start_date" :value="__('Start Date')" />
                                <x-text-input id="start_date" name="start_date" type="date" 
                                    value="{{ $startDate }}" class="block w-full mt-1" />
                            </div>
                            <div>
                                <x-input-label for="end_date" :value="__('End Date')" />
                                <x-text-input id="end_date" name="end_date" type="date" 
                                    value="{{ $endDate }}" class="block w-full mt-1" />
                            </div>
                            <div class="flex items-end">
                                <x-primary-button type="submit">
                                    {{ __('Filter') }}
                                </x-primary-button>
                               <x-secondary-button type="button" onclick="window.open('{{ route('reports.print.stock-outputs') }}?start_date={{ $startDate }}&end_date={{ $endDate }}', '_blank')" class="ml-2">
                                   {{ __('Print Report') }}
                               </x-secondary-button>
                            </div>
                        </div>
                    </form>

                    <!-- Summary Cards -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div class="bg-blue-50 dark:bg-gray-700 p-4 rounded-lg">
                            <h3 class="font-semibold text-blue-800 dark:text-blue-200">Total Quantity</h3>
                            <p class="text-2xl font-bold">{{ $totals['quantity'] }}</p>
                        </div>
                        <div class="bg-green-50 dark:bg-gray-700 p-4 rounded-lg">
                            <h3 class="font-semibold text-green-800 dark:text-green-200">Total Value</h3>
                            <p class="text-2xl font-bold">TZS {{ number_format($totals['value']) }}</p>
                        </div>
                    </div>

                    <!-- Outputs Table -->
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                            <thead class="bg-gray-50 dark:bg-gray-700">
                                <tr>
                                    <th class="px-6 py-3 text-left">Date</th>
                                    <th class="px-6 py-3 text-left">Product</th>
                                    <th class="px-6 py-3 text-left">Output By</th>
                                    <th class="px-6 py-3 text-left">Output To</th>
                                    <th class="px-6 py-3 text-left">Quantity</th>
                                    <th class="px-6 py-3 text-left">Reason</th>
                                    <th class="px-6 py-3 text-left">Value</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                @foreach($outputs as $output)
                                <tr>
                                    <td class="px-6 py-4">{{ $output->created_at->format('d/m/Y H:i') }}</td>
                                    <td class="px-6 py-4">{{ $output->product->name }}</td>
                                    <td class="px-6 py-4">{{ $output->outputByUser->name }}</td>
                                    <td class="px-6 py-4">{{ $output->outputToUser->name ?? 'N/A' }}</td>
                                    <td class="px-6 py-4">{{ $output->quantity }}</td>
                                    <td class="px-6 py-4">{{ $output->reason ?? 'N/A' }}</td>
                                    <td class="px-6 py-4">TZS {{ number_format($output->quantity * $output->product->input_price_per_unit) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>