<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Monthly Comprehensive Financial Report') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <h1 class="text-3xl font-bold mb-6 text-gray-800">Monthly Comprehensive Financial Report - {{ $monthName }} {{ $year }}</h1>

                    <div class="bg-white shadow-md rounded-lg p-6 mb-8">
                        <h2 class="text-2xl font-semibold mb-4 text-indigo-700">Statement of Financial Position (Balance Sheet)</h2>
                        <p class="text-gray-600 mb-4">As of {{ $balanceSheet['reportDate'] }}</p>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                            {{-- Assets Section --}}
                            <div>
                                <h3 class="text-xl font-bold mb-3 text-gray-700">Assets</h3>
                                <div class="space-y-2">
                                    <p class="font-semibold text-lg text-gray-800 mb-2">Current Assets</p>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Cash Balance:</span>
                                        <span class="font-medium text-gray-900">${{ number_format($balanceSheet['assets']['current']['cash'], 2) }}</span>
                                    </div>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Inventory:</span>
                                        <span class="font-medium text-gray-900">${{ number_format($balanceSheet['assets']['current']['inventory'], 2) }}</span>
                                    </div>
                                    {{-- Add other current assets if any --}}
                                    <div class="flex justify-between items-center font-bold border-t pt-2 text-md">
                                        <span>Total Current Assets:</span>
                                        <span>${{ number_format($balanceSheet['assets']['current']['total'], 2) }}</span>
                                    </div>

                                    <p class="font-semibold text-lg text-gray-800 mt-4 mb-2">Non-Current Assets</p>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Fixed Assets:</span>
                                        <span class="font-medium text-gray-900">${{ number_format($balanceSheet['assets']['nonCurrent']['fixedAssets'], 2) }}</span>
                                    </div>
                                    {{-- Add other non-current assets if any --}}
                                    <div class="flex justify-between items-center font-bold border-t pt-2 text-md">
                                        <span>Total Non-Current Assets:</span>
                                        <span>${{ number_format($balanceSheet['assets']['nonCurrent']['total'], 2) }}</span>
                                    </div>

                                    <div class="flex justify-between items-center font-bold text-lg border-t-2 pt-4 text-green-700">
                                        <span>TOTAL ASSETS:</span>
                                        <span>${{ number_format($balanceSheet['assets']['totalAssets'], 2) }}</span>
                                    </div>
                                </div>
                            </div>

                            {{-- Liabilities & Equity Section --}}
                            <div>
                                <h3 class="text-xl font-bold mb-3 text-gray-700">Liabilities & Equity</h3>
                                <div class="space-y-2">
                                    <p class="font-semibold text-lg text-gray-800 mb-2">Liabilities</p>
                                    <p class="font-semibold text-md text-gray-700 mb-1">Current Liabilities</p>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Bank Overdraft:</span>
                                        <span class="font-medium text-gray-900">${{ number_format($balanceSheet['liabilities']['current']['accountsPayable'], 2) }}</span>
                                    </div>
                                    {{-- Add other current liabilities if any --}}
                                    <div class="flex justify-between items-center font-bold border-t pt-2 text-md">
                                        <span>Total Current Liabilities:</span>
                                        <span>${{ number_format($balanceSheet['liabilities']['current']['total'], 2) }}</span>
                                    </div>

                                    <p class="font-semibold text-md text-gray-700 mt-4 mb-1">Non-Current Liabilities</p>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Loans Payable:</span>
                                        <span class="font-medium text-gray-900">${{ number_format($balanceSheet['liabilities']['nonCurrent']['loans'], 2) }}</span>
                                    </div>
                                    {{-- Add other non-current liabilities if any --}}
                                    <div class="flex justify-between items-center font-bold border-t pt-2 text-md">
                                        <span>Total Non-Current Liabilities:</span>
                                        <span>${{ number_format($balanceSheet['liabilities']['nonCurrent']['total'], 2) }}</span>
                                    </div>

                                    <div class="flex justify-between items-center font-bold text-md border-t pt-2 text-gray-800">
                                        <span>TOTAL LIABILITIES:</span>
                                        <span>${{ number_format($balanceSheet['liabilities']['totalLiabilities'], 2) }}</span>
                                    </div>

                                    <p class="font-semibold text-lg text-gray-800 mt-4 mb-2">Equity</p>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Initial Capital:</span>
                                        <span class="font-medium text-gray-900">${{ number_format($balanceSheet['equity']['capital'], 2) }}</span>
                                    </div>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Retained Earnings:</span>
                                        <span class="font-medium text-gray-900">${{ number_format($balanceSheet['equity']['retainedEarnings'], 2) }}</span>
                                    </div>
                                    <div class="flex justify-between items-center border-b pb-1">
                                        <span class="text-gray-700">Net Profit (Current Period):</span>
                                        <span class="font-medium text-gray-900">${{ number_format($balanceSheet['equity']['currentProfit'], 2) }}</span>
                                    </div>
                                    <div class="flex justify-between items-center font-bold border-t pt-2 text-md">
                                        <span>TOTAL EQUITY:</span>
                                        <span>${{ number_format($balanceSheet['equity']['totalEquity'], 2) }}</span>
                                    </div>

                                    <div class="flex justify-between items-center font-bold text-lg border-t-2 pt-4 text-green-700">
                                        <span>TOTAL LIABILITIES & EQUITY:</span>
                                        <span>${{ number_format($balanceSheet['liabilities']['totalLiabilities'] + $balanceSheet['equity']['totalEquity'], 2) }}</span>
                                    </div>

                                    @if(!$balanceSheet['isBalanced'])
                                        <p class="text-red-600 font-bold mt-4">Warning: Balance Sheet is not balanced! Difference: ${{ number_format($balanceSheet['balanceCheck'], 2) }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Unaweza kuongeza sehemu zingine za Income Statement, Cash Flow, n.k. hapa chini --}}
                    {{-- Example for Income Statement (assuming it's also passed in $data) --}}
                    {{--
                    <div class="bg-white shadow-md rounded-lg p-6 mb-8">
                        <h2 class="text-2xl font-semibold mb-4 text-indigo-700">Income Statement</h2>
                        <p class="text-gray-600 mb-4">For the period {{ $incomeStatement['periodLabel'] }}</p>
                        <div class="space-y-2">
                            <div class="flex justify-between items-center">
                                <span>Net Sales:</span>
                                <span>${{ number_format($incomeStatement['netSales'], 2) }}</span>
                            </div>
                            <div class="flex justify-between items-center">
                                <span>Cost of Goods Sold (COGS):</span>
                                <span>${{ number_format($incomeStatement['cogs'], 2) }}</span>
                            </div>
                            <div class="flex justify-between items-center font-bold border-t pt-2">
                                <span>Gross Profit:</span>
                                <span>${{ number_format($incomeStatement['grossProfit'], 2) }}</span>
                            </div>
                            <p class="font-semibold text-lg text-gray-800 mt-4 mb-2">Operating Expenses</p>
                            @foreach($incomeStatement['operatingExpenses'] as $expenseCategory => $amount)
                            <div class="flex justify-between items-center border-b pb-1">
                                <span>{{ $expenseCategory }}:</span>
                                <span>${{ number_format($amount, 2) }}</span>
                            </div>
                            @endforeach
                            <div class="flex justify-between items-center border-b pb-1">
                                <span>Salaries:</span>
                                <span>${{ number_format($incomeStatement['salaries'], 2) }}</span>
                            </div>
                            <div class="flex justify-between items-center font-bold border-t pt-2">
                                <span>Total Operating Expenses:</span>
                                <span>${{ number_format($incomeStatement['totalOperatingExpenses'], 2) }}</span>
                            </div>
                            <div class="flex justify-between items-center font-bold text-lg border-t-2 pt-4">
                                <span>NET PROFIT:</span>
                                <span>${{ number_format($incomeStatement['netProfit'], 2) }}</span>
                            </div>
                        </div>
                    </div>
                    --}}
                </div>
            </div>
        </div>
    </div>
</x-app-layout>