<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="{{ asset('images/CAMON.jpg') }}" type="image/jpg">
    <title>Income Statement - {{ $reportData['title'] }}</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @media print {
            body { 
                font-size: 12px;
                background-color: white;
            }
            .no-print { 
                display: none !important; 
            }
            @page { 
                size: A4;
                margin: 10mm;
            }
            .print-section {
                break-inside: avoid;
            }
            .summary-section {
                page-break-before: avoid;
                page-break-after: avoid;
                page-break-inside: avoid;
            }
        }
        body {
            font-family: Arial, sans-serif;
        }
        .header-section {
            background-color: rgb(247, 181, 2);
            color: white;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            border-radius: 0.5rem;
        }
        .activity-header {
            background-color: rgb(247, 181, 2);
            color: white;
            padding: 0.75rem 1rem;
            border-radius: 0.5rem 0.5rem 0 0;
            font-weight: bold;
            font-size: 1.1rem;
        }
        .activity-card {
            border: 1px solid #e5e7eb;
            border-radius: 0.5rem;
            margin-bottom: 1.5rem;
            overflow: hidden;
        }
        .activity-body {
            padding: 1rem;
        }
        .summary-card {
            background-color: #1f2937;
            color: white;
            border-radius: 0.5rem;
            padding: 1.5rem;
            margin-top: 1.5rem;
        }
        .negative-value {
            color: #ef4444;
        }
        .positive-value {
            color: #10b981;
        }
        .company-name {
            font-size: 24px;
            font-weight: bold;
            margin-bottom: 5px;
        }
        .report-title {
            font-size: 20px;
            margin-bottom: 10px;
        }
        .period {
            font-size: 16px;
            margin-bottom: 5px;
        }
        .date-generated {
            font-size: 14px;
            color: #666;
        }
        .section {
            margin-bottom: 15px;
        }
        .section-title {
            font-weight: bold;
            font-size: 18px;
            border-bottom: 1px solid #333;
            padding-bottom: 5px;
            margin-bottom: 10px;
        }
        .item-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }
        .item-label {
            padding-left: 20px;
        }
        .item-value {
            text-align: right;
        }
        .subtotal {
            font-weight: bold;
            border-top: 1px solid #333;
            padding-top: 5px;
            margin-top: 5px;
        }
        .total {
            font-weight: bold;
            font-size: 18px;
            border-top: 2px solid #333;
            padding-top: 10px;
            margin-top: 10px;
        }
        .positive {
            color: #008000;
        }
        .negative {
            color: #FF0000;
        }
        .footer {
            margin-top: 30px;
            font-size: 12px;
            text-align: center;
            color: #666;
            border-top: 1px solid #ccc;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <!-- Print Controls (Visible only on screen) -->
    <div class="no-print flex justify-center gap-4 my-4">
        <button onclick="window.print()" class="bg-blue-500 hover:bg-blue-600 text-white px-4 py-2 rounded-md flex items-center">
            <i class="fas fa-print mr-2"></i> Print Report
        </button>
        <button onclick="window.close()" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-md flex items-center">
            <i class="fas fa-times mr-2"></i> Close
        </button>
    </div>

    <!-- Report Container -->
    <div class="container mx-auto px-4 py-6">
        <!-- Header Section -->
        <div class="header-section text-center">
            <div class="company-name">CAMON ENTERPRISES LIMITED</div>
            <div class="report-title">INCOME STATEMENT</div>
            <div class="period">For the Period: {{ $periodLabel }}</div>
            <div class="date-generated">Generated on: {{ now()->format('M d, Y h:i A') }}</div>
        </div>

        <!-- Revenue Section -->
        <div class="activity-card print-section">
            <div class="activity-header">
                <i class="fas fa-money-bill-wave mr-2"></i> REVENUE
            </div>
            <div class="activity-body">
                <div class="item-row">
                    <div class="item-label">Gross Sales</div>
                    <div class="item-value">TZS {{ number_format($reportData['grossSales'], 2) }}</div>
                </div>

                <div class="item-row">
                    <div class="item-label">Less: Sales Returns</div>
                    <div class="item-value negative">(TZS {{ number_format($reportData['salesReturns'], 2) }})</div>
                </div>

                <div class="item-row">
                    <div class="item-label">Add: Other Income</div>
                    <div class="item-value positive">TZS {{ number_format($reportData['otherIncomes'], 2) }}</div>
                </div>

                <div class="item-row subtotal">
                    <div>Net Sales</div>
                    <div class="positive">TZS {{ number_format($reportData['netSales'], 2) }}</div>
                </div>
            </div>
        </div>

        <!-- COGS Section -->
        <div class="activity-card print-section">
            <div class="activity-header">
                <i class="fas fa-boxes mr-2"></i> COST OF GOODS SOLD (COGS) CALCULATION
            </div>
            <div class="activity-body">
                <div class="item-row">
                    <div class="item-label">Opening Inventory</div>
                    <div class="item-value">TZS {{ number_format($reportData['openingInventory'], 2) }}</div>
                </div>

                <div class="item-row">
                    <div class="item-label">Add: Total Purchases Value</div>
                    <div class="item-value">TZS {{ number_format($reportData['totalPurchasesValue'], 2) }}</div>
                </div>

                <div class="item-row">
                    <div class="item-label">Less: Purchase Returns Cost</div>
                    <div class="item-value negative">(TZS {{ number_format($reportData['purchaseReturnsCost'], 2) }})</div>
                </div>
                
                <div class="item-row">
                    <div class="item-label">Add: Carriage Inwards</div>
                    <div class="item-value">TZS {{ number_format($reportData['carriageInwards'], 2) }}</div>
                </div>

                <div class="item-row">
                    <div class="item-label">Less: Closing Inventory</div>
                    <div class="item-value negative">(TZS {{ number_format($reportData['closingInventory'], 2) }})</div>
                </div>

                <div class="item-row subtotal">
                    <div>Cost of Goods Sold (COGS)</div>
                    <div class="negative">(TZS {{ number_format($reportData['cogs'], 2) }})</div>
                </div>
            </div>
        </div>

        <!-- Gross Profit -->
        <div class="activity-card print-section">
            <div class="activity-body">
                <div class="item-row total">
                    <div>GROSS PROFIT</div>
                    <div class="positive">TZS {{ number_format($reportData['grossProfit'], 2) }}</div>
                </div>
            </div>
        </div>

        <!-- Operating Expenses -->
        <div class="activity-card print-section">
            <div class="activity-header">
                <i class="fas fa-file-invoice-dollar mr-2"></i> OPERATING EXPENSES
            </div>
            <div class="activity-body">
                @if($reportData['operatingExpenses']->isNotEmpty())
                    @foreach ($reportData['operatingExpenses'] as $category => $amount)
                        <div class="item-row">
                            <div class="item-label">{{ $category }}</div>
                            <div class="item-value negative">(TZS {{ number_format($amount, 2) }})</div>
                        </div>
                    @endforeach
                @else
                    <div class="item-row">
                        <div class="item-label">No general operating expenses recorded</div>
                        <div class="item-value">TZS 0.00</div>
                    </div>
                @endif

                <div class="item-row">
                    <div class="item-label">Salaries</div>
                    <div class="item-value negative">(TZS {{ number_format($reportData['salaries'], 2) }})</div>
                </div>
                
                <div class="item-row subtotal">
                    <div>Total Operating Expenses</div>
                    <div class="negative">(TZS {{ number_format($reportData['totalOperatingExpenses'], 2) }})</div>
                </div>
            </div>
        </div>

        <!-- Net Profit -->
        <div class="activity-card print-section summary-section">
            <div class="activity-body">
                <div class="item-row total">
                    <div>NET PROFIT (OR LOSS)</div>
                    <div class="@if($reportData['netProfit'] >= 0) positive @else negative @endif">
                        TZS {{ number_format($reportData['netProfit'], 2) }}
                    </div>
                </div>
                <div class="@if($reportData['netProfit'] >= 0) positive @else negative @endif text-center mt-2 font-bold">
                    {{ $reportData['netProfit'] >= 0 ? 'PROFIT' : 'LOSS' }} FOR THE PERIOD
                </div>
            </div>
        </div>

        <!-- Footer -->
        <div class="mt-8 text-center text-sm text-gray-600 no-print">
            <p>Generated by: {{ Auth::user()->name ?? 'System' }}</p>
            <p>Generated on: {{ now()->format('d/m/Y H:i') }}</p>
            <p class="mt-2">© {{ date('Y') }} Camon Enterprises Limited. All rights reserved.</p>
        </div>
    </div>

    <script>
        // Auto focus print button for better UX
        window.onload = function() {
            const printBtn = document.querySelector('.no-print button');
            if (printBtn) printBtn.focus();
        };
    </script>
</body>
</html>