<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ $reportData['title'] }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-5xl mx-auto sm:px-6 lg:px-8">
            <div class="mb-8 bg-white dark:bg-gray-800 shadow rounded-lg p-6">
                <form method="GET" action="{{ route('reports.income-statement') }}">
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                        <div>
                            <x-input-label for="period" :value="__('Select Period')" />
                            <select id="period" name="period" class="block w-full mt-1 border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-300 focus:border-indigo-500 dark:focus:border-indigo-600 focus:ring-indigo-500 dark:focus:ring-indigo-600 rounded-md shadow-sm">
                                <option value="today" {{ request('period') === 'today' ? 'selected' : '' }}>Today</option>
                                <option value="week" {{ request('period') === 'week' ? 'selected' : '' }}>This Week</option>
                                <option value="month" {{ request('period') === 'month' ? 'selected' : '' }}>This Month</option>
                                <option value="year" {{ request('period') === 'year' ? 'selected' : '' }}>This Year</option>
                                <option value="custom" {{ request('period') === 'custom' ? 'selected' : '' }}>Custom Range</option>
                            </select>
                        </div>
                        
                        <div id="start_date_container" style="{{ request('period') !== 'custom' ? 'display: none;' : '' }}">
                            <x-input-label for="start_date" :value="__('Start Date')" />
                            <x-text-input id="start_date" name="start_date" type="date" 
                                value="{{ request('start_date', $startDate) }}" class="block w-full mt-1" />
                        </div>
                        
                        <div id="end_date_container" style="{{ request('period') !== 'custom' ? 'display: none;' : '' }}">
                            <x-input-label for="end_date" :value="__('End Date')" />
                            <x-text-input id="end_date" name="end_date" type="date" 
                                value="{{ request('end_date', $endDate) }}" class="block w-full mt-1" />
                        </div>
                        
                        <div class="flex items-end space-x-2">
                            <x-primary-button type="submit" class="w-full">
                                {{ __('Apply Filter') }}
                            </x-primary-button>
                        </div>
                        <div class="flex items-end space-x-2">
                           <x-primary-button 
                                type="button" 
                                onclick="window.open('{{ route('reports.income-statement.pdf', [
                                        'period' => request('period', 'month'),
                                        'start_date' => request('start_date', $startDate),
                                        'end_date' => request('end_date', $endDate)
                                    ]) }}', '_blank')"
                                class="flex items-center"
                            >
                                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                                </svg>
                                {{ __('Print Report') }}
                            </x-primary-button>
                        </div>
                    </div>
                </form>
            </div>

            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-8 text-gray-900 dark:text-gray-100">
                    <div class="flex flex-col md:flex-row justify-between items-start md:items-center mb-6 pb-4 border-b border-gray-200 dark:border-gray-700">
                        <div class="mb-4 md:mb-0">
                            <h3 class="text-lg font-medium text-gray-700 dark:text-gray-300">
                                For the Period: <span class="font-semibold">{{ $periodLabel }}</span>
                            </h3>
                            <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                                Generated on: {{ now()->format('M d, Y h:i A') }}
                            </p>
                        </div>
                    </div>

                    <div class="space-y-8">
                        <div class="space-y-4">
                            <h3 class="font-semibold text-lg text-gray-800 dark:text-gray-200">
                                Revenue
                            </h3>
                            
                            <div class="flex justify-between items-center pb-2">
                                <span class="text-gray-700 dark:text-gray-300 pl-4">
                                    Gross Sales
                                </span>
                                <span class="font-medium text-gray-800 dark:text-gray-200">
                                    TZS {{ number_format($reportData['grossSales'], 2) }}
                                </span>
                            </div>

                            <div class="flex justify-between items-center pb-2">
                                <span class="text-gray-700 dark:text-gray-300 pl-4">
                                    Less: Sales Returns
                                </span>
                                <span class="font-medium text-red-600 dark:text-red-400">
                                    (TZS {{ number_format($reportData['salesReturns'], 2) }})
                                </span>
                            </div>

                            <div class="flex justify-between items-center pb-2">
                                <span class="text-gray-700 dark:text-gray-300 pl-4">
                                    Add: Other Income
                                </span>
                                <span class="font-medium text-green-700 dark:text-green-400">
                                    TZS {{ number_format($reportData['otherIncomes'], 2) }}
                                </span>
                            </div>

                            <div class="flex justify-between items-center pt-2 border-t border-gray-300 dark:border-gray-600">
                                <span class="font-semibold text-gray-800 dark:text-gray-200">
                                    Net Sales
                                </span>
                                <span class="font-semibold text-green-700 dark:text-green-400">
                                    TZS {{ number_format($reportData['netSales'], 2) }}
                                </span>
                            </div>
                        </div>

                        <div class="space-y-4">
                            <h3 class="font-semibold text-lg text-gray-800 dark:text-gray-200">
                                Cost of Goods Sold (COGS) Calculation
                            </h3>
                            
                            <div class="flex justify-between items-center pb-2">
                                <span class="text-gray-700 dark:text-gray-300 pl-4">
                                    Opening Inventory
                                </span>
                                <span class="font-medium text-gray-800 dark:text-gray-200">
                                    TZS {{ number_format($reportData['openingInventory'], 2) }}
                                </span>
                            </div>

                            <div class="flex justify-between items-center pb-2">
                                <span class="text-gray-700 dark:text-gray-300 pl-4">
                                    Add: Total Purchases Value
                                </span>
                                <span class="font-medium text-gray-800 dark:text-gray-200">
                                    TZS {{ number_format($reportData['totalPurchasesValue'], 2) }}
                                </span>
                            </div>

                            <div class="flex justify-between items-center pb-2">
                                <span class="text-gray-700 dark:text-gray-300 pl-4">
                                    Less: Purchase Returns Cost
                                </span>
                                <span class="font-medium text-red-600 dark:text-red-400">
                                    (TZS {{ number_format($reportData['purchaseReturnsCost'], 2) }})
                                </span>
                            </div>
                            
                            <div class="flex justify-between items-center pb-2">
                                <span class="text-gray-700 dark:text-gray-300 pl-4">
                                    Add: Carriage Inwards
                                </span>
                                <span class="font-medium text-gray-800 dark:text-gray-200">
                                    TZS {{ number_format($reportData['carriageInwards'], 2) }}
                                </span>
                            </div>

                            <div class="flex justify-between items-center pb-2">
                                <span class="text-gray-700 dark:text-gray-300 pl-4">
                                    Less: Closing Inventory
                                </span>
                                <span class="font-medium text-red-600 dark:text-red-400">
                                    (TZS {{ number_format($reportData['closingInventory'], 2) }})
                                </span>
                            </div>

                            <div class="flex justify-between items-center pt-2 border-t border-gray-300 dark:border-gray-600">
                                <span class="font-semibold text-gray-800 dark:text-gray-200">
                                    Cost of Goods Sold (COGS)
                                </span>
                                <span class="font-semibold text-red-600 dark:text-red-400">
                                    (TZS {{ number_format($reportData['cogs'], 2) }})
                                </span>
                            </div>
                        </div>

                        <div class="flex justify-between items-center pt-2 border-t-2 border-gray-300 dark:border-gray-600">
                            <h3 class="font-semibold text-lg text-gray-800 dark:text-gray-200">
                                Gross Profit
                            </h3>
                            <span class="font-semibold text-green-700 dark:text-green-400">
                                TZS {{ number_format($reportData['grossProfit'], 2) }}
                            </span>
                        </div>

                        <div class="space-y-4">
                            <h3 class="font-semibold text-lg text-gray-800 dark:text-gray-200">
                                Operating Expenses
                            </h3>
                            
                            {{-- Loop through the grouped operating expenses --}}
                            @if($reportData['operatingExpenses']->isNotEmpty())
                                @foreach ($reportData['operatingExpenses'] as $category => $amount)
                                    <div class="flex justify-between items-center pb-2">
                                        <span class="text-gray-700 dark:text-gray-300 pl-4">
                                            {{ $category }}
                                        </span>
                                        <span class="font-medium text-red-600 dark:text-red-400">
                                            (TZS {{ number_format($amount, 2) }})
                                        </span>
                                    </div>
                                @endforeach
                            @else
                                <div class="flex justify-between items-center pb-2">
                                    <span class="text-gray-700 dark:text-gray-300 pl-4">
                                        No general operating expenses recorded.
                                    </span>
                                    <span class="font-medium text-gray-500 dark:text-gray-400">
                                        TZS 0.00
                                    </span>
                                </div>
                            @endif

                            <div class="flex justify-between items-center pb-2">
                                <span class="text-gray-700 dark:text-gray-300 pl-4">
                                    Salaries
                                </span>
                                <span class="font-medium text-red-600 dark:text-red-400">
                                    (TZS {{ number_format($reportData['salaries'], 2) }})
                                </span>
                            </div>
                            
                            <div class="flex justify-between items-center pt-2 border-t border-gray-300 dark:border-gray-600">
                                <span class="font-semibold text-gray-800 dark:text-gray-200">
                                    Total Operating Expenses
                                </span>
                                <span class="font-semibold text-red-600 dark:text-red-400">
                                    (TZS {{ number_format($reportData['totalOperatingExpenses'], 2) }})
                                </span>
                            </div>
                        </div>

                        <div class="space-y-4 pt-6 border-t-2 border-gray-300 dark:border-gray-600">
                            <div class="flex justify-between items-center">
                                <h3 class="text-xl font-bold text-gray-800 dark:text-gray-200">
                                    Net Profit (or Loss)
                                </h3>
                                <span class="text-2xl font-bold @if($reportData['netProfit'] >= 0) text-green-700 dark:text-green-400 @else text-red-600 dark:text-red-400 @endif">
                                    TZS {{ number_format($reportData['netProfit'], 2) }}
                                </span>
                            </div>
                            <p class="text-sm text-center @if($reportData['netProfit'] >= 0) text-green-600 dark:text-green-300 @else text-red-600 dark:text-red-300 @endif">
                                {{ $reportData['netProfit'] >= 0 ? 'Profit' : 'Loss' }} for the period
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Show/hide custom date fields based on period selection
        document.getElementById('period').addEventListener('change', function() {
            const showCustom = this.value === 'custom';
            document.getElementById('start_date_container').style.display = showCustom ? 'block' : 'none';
            document.getElementById('end_date_container').style.display = showCustom ? 'block' : 'none';
        });

        // Initialize visibility on page load
        document.addEventListener('DOMContentLoaded', function() {
            const periodSelect = document.getElementById('period');
            const showCustom = periodSelect.value === 'custom';
            document.getElementById('start_date_container').style.display = showCustom ? 'block' : 'none';
            document.getElementById('end_date_container').style.display = showCustom ? 'block' : 'none';
        });
    </script>
</x-app-layout>