<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Statement Of Financial Position Report') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <h3 class="text-2xl font-bold text-center mb-4">CAMON'S {{ $reportData['title'] }} as of {{ $reportData['reportDate'] }}</h3>

                    <form action="{{ route('reports.balance-sheet') }}" method="GET" class="mb-4">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
                            <div>
                                <label for="report_date" class="block text-sm font-medium text-gray-700">Select Report Date:</label>
                                <input type="date" name="report_date" id="report_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" value="{{ request('report_date', \Carbon\Carbon::now()->format('Y-m-d')) }}">
                            </div>
                            <div class="flex items-end space-x-2">
                                <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                    Generate Report
                                </button>
                                <a href="{{ route('reports.balance-sheet.pdf', ['report_date' => request('report_date', \Carbon\Carbon::now()->format('Y-m-d'))]) }}" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500" target="_blank">
                                    Download PDF
                                </a>
                            </div>
                        </div>
                    </form>

                    <hr class="my-6 border-gray-300">

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                        <div>
                            <h4 class="text-xl font-semibold mb-2">ASSETS</h4>
                            <hr class="mb-4">
                            <h5 class="text-lg font-semibold mb-2">Current Assets</h5>
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200 border border-gray-200">
                                    <thead>
                                        <tr class="bg-gray-50">
                                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Asset</th>
                                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Amount (TZS)</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        <tr>
                                            <td class="px-6 py-3 whitespace-nowrap">Inventory</td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right">{{ number_format($reportData['assets']['current']['inventory'], 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 whitespace-nowrap">Cash</td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right">{{ number_format($reportData['assets']['current']['cash'], 2) }}</td>
                                        </tr>
                                        <tr class="bg-blue-50 text-blue-800 font-bold">
                                            <td class="px-6 py-3 whitespace-nowrap"><strong>Total Current Assets</strong></td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right"><strong>{{ number_format($reportData['assets']['current']['total'], 2) }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            {{-- Non-Current Assets section removed as per requirement --}}
                            {{-- <h5 class="text-lg font-semibold mt-6 mb-2">Non-Current Assets</h5>
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200 border border-gray-200">
                                    <thead>
                                        <tr class="bg-gray-50">
                                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Asset</th>
                                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Amount (TZS)</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        <tr>
                                            <td class="px-6 py-3 whitespace-nowrap">Fixed Assets (Net Book Value)</td> 
                                            <td class="px-6 py-3 whitespace-nowrap text-right">{{ number_format($reportData['assets']['nonCurrent']['fixedAssets'], 2) }}</td>
                                        </tr>
                                        <tr class="bg-blue-100 text-blue-900 font-bold">
                                            <td class="px-6 py-3 whitespace-nowrap"><strong>Total Non-Current Assets</strong></td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right"><strong>{{ number_format($reportData['assets']['nonCurrent']['total'], 2) }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div> --}}

                            <h5 class="text-xl font-semibold mt-6 mb-2">TOTAL ASSETS</h5>
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200 border border-gray-200">
                                    <thead>
                                        <tr class="bg-gray-50">
                                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Summary</th>
                                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Amount (TZS)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="bg-indigo-100 text-indigo-900 font-bold text-lg">
                                            <td class="px-6 py-3 whitespace-nowrap"><strong>TOTAL ASSETS</strong></td>
                                            {{-- Now total assets will only be current assets --}}
                                            <td class="px-6 py-3 whitespace-nowrap text-right"><strong>{{ number_format($reportData['assets']['current']['total'], 2) }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <div>
                            <h4 class="text-xl font-semibold mb-2">LIABILITIES & EQUITY</h4>
                            <hr class="mb-4">
                            <h5 class="text-lg font-semibold mb-2">Current Liabilities</h5>
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200 border border-gray-200">
                                    <thead>
                                        <tr class="bg-gray-50">
                                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Liability</th>
                                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Amount (TZS)</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        <tr>
                                            <td class="px-6 py-3 whitespace-nowrap">Accounts Payable</td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right">{{ number_format($reportData['liabilities']['current']['accountsPayable'], 2) }}</td>
                                        </tr>
                                        <tr class="bg-blue-50 text-blue-800 font-bold">
                                            <td class="px-6 py-3 whitespace-nowrap"><strong>Total Current Liabilities</strong></td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right"><strong>{{ number_format($reportData['liabilities']['current']['total'], 2) }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <h5 class="text-lg font-semibold mt-6 mb-2">Non-Current Liabilities</h5>
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200 border border-gray-200">
                                    <thead>
                                        <tr class="bg-gray-50">
                                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Liability</th>
                                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Amount (TZS)</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        <tr>
                                            <td class="px-6 py-3 whitespace-nowrap">Long-term Loans</td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right">{{ number_format($reportData['liabilities']['nonCurrent']['loans'], 2) }}</td>
                                        </tr>
                                        <tr class="bg-blue-50 text-blue-800 font-bold">
                                            <td class="px-6 py-3 whitespace-nowrap"><strong>Total Non-Current Liabilities</strong></td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right"><strong>{{ number_format($reportData['liabilities']['nonCurrent']['total'], 2) }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <h5 class="text-xl font-semibold mt-6 mb-2">TOTAL LIABILITIES</h5>
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200 border border-gray-200">
                                    <thead>
                                        <tr class="bg-gray-50">
                                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Summary</th>
                                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Amount (TZS)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="bg-yellow-100 text-yellow-800 font-bold">
                                            <td class="px-6 py-3 whitespace-nowrap"><strong>TOTAL LIABILITIES</strong></td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right"><strong>{{ number_format($reportData['liabilities']['totalLiabilities'], 2) }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <h4 class="text-xl font-semibold mt-6 mb-2">EQUITY</h4>
                            <hr class="mb-4">
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200 border border-gray-200">
                                    <thead>
                                        <tr class="bg-gray-50">
                                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Equity Item</th>
                                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Amount (TZS)</th>
                                        </tr>
                                    </thead>
                                    <tbody class="bg-white divide-y divide-gray-200">
                                        <tr>
                                            <td class="px-6 py-3 whitespace-nowrap">Initial Capital</td> 
                                            <td class="px-6 py-3 whitespace-nowrap text-right">{{ number_format($reportData['equity']['capital'], 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 whitespace-nowrap">Retained Earnings</td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right">{{ number_format($reportData['equity']['retainedEarnings'], 2) }}</td>
                                        </tr>
                                        <tr>
                                            <td class="px-6 py-3 whitespace-nowrap">Current Month's Profit</td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right">{{ number_format($reportData['equity']['currentProfit'], 2) }}</td>
                                        </tr>
                                        <tr class="bg-blue-50 text-blue-800 font-bold">
                                            <td class="px-6 py-3 whitespace-nowrap"><strong>Total Equity</strong></td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right"><strong>{{ number_format($reportData['equity']['totalEquity'], 2) }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                            <h5 class="text-xl font-semibold mt-6 mb-2">TOTAL LIABILITIES & EQUITY</h5>
                            <div class="overflow-x-auto">
                                <table class="min-w-full divide-y divide-gray-200 border border-gray-200">
                                    <thead>
                                        <tr class="bg-gray-50">
                                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Summary</th>
                                            <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Amount (TZS)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr class="bg-indigo-100 text-indigo-900 font-bold text-lg">
                                            <td class="px-6 py-3 whitespace-nowrap"><strong>TOTAL LIABILITIES & EQUITY</strong></td>
                                            <td class="px-6 py-3 whitespace-nowrap text-right"><strong>{{ number_format($reportData['liabilities']['totalLiabilities'] + $reportData['equity']['totalEquity'], 2) }}</strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="mt-8 p-4 rounded-md {{ $reportData['isBalanced'] ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                        <strong class="font-bold">Balance Check:</strong> Assets - (Liabilities + Equity) = {{ number_format($reportData['balanceCheck'], 2) }}
                        @if($reportData['isBalanced'])
                            <p class="mt-1">The Balance Sheet is balanced! Great job!</p>
                        @else
                            <p class="mt-1">The Balance Sheet is NOT balanced. This indicates a discrepancy in your financial records. Please review your data and calculations.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>