<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Product Details') }} - {{ $product->name }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <!-- Product Information -->
                        <div class="space-y-4">
                            <div>
                                <h3 class="text-lg font-medium text-gray-900">Product Information</h3>
                                <div class="mt-4 space-y-2">
                                    <p><span class="font-medium">Name:</span> {{ $product->name }}</p>
                                    <p><span class="font-medium">Unit:</span> {{ $product->unit }}</p>
                                    <p><span class="font-medium">Input Price:</span> {{ number_format($product->input_price_per_unit, 2) }}</p>
                                    <p><span class="font-medium">Selling Price:</span> {{ number_format($product->selling_price_per_unit, 2) }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Stock Information -->
                        <div class="space-y-4">
                            <div>
                                <h3 class="text-lg font-medium text-gray-900">Stock Information</h3>
                                <div class="mt-4 space-y-2">
                                    <p><span class="font-medium">Total Input Quantity:</span> {{ $totalInput }}</p>
                                    <p><span class="font-medium">Total Output Quantity:</span> {{ $totalOutput }}</p>
                                    <p><span class="font-medium">Remaining Quantity:</span> {{ $remaining }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Financial Information -->
                        <div class="space-y-4">
                            <div>
                                <h3 class="text-lg font-medium text-gray-900">Financial Information</h3>
                                <div class="mt-4 space-y-2">
                                    <p><span class="font-medium">Profit Per Unit:</span> {{ number_format($profitPerUnit, 2) }}</p>
                                    <p><span class="font-medium">Total Potential Profit:</span> {{ number_format($totalProfit, 2) }}</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="mt-6">
                        <a href="{{ route('products.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-800 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-gray-700 active:bg-gray-900 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150">
                            Back to Products
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>