<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Stock Overview') }} - {{ Auth::user()->role }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    
                    <!-- Search Form -->
                    <div class="mb-6">
                        <form method="GET" action="{{ route('products.overview') }}">
                            <div class="flex">
                                <input type="text" name="search" placeholder="Search products..." 
                                       value="{{ request('search') }}"
                                       class="rounded-l-md border-gray-300 focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50">
                                <button type="submit" class="bg-indigo-500 text-white px-4 py-2 rounded-r-md hover:bg-indigo-600">
                                    Search
                                </button>
                            </div>
                        </form>
                    </div>

                    <!-- Summary Cards -->
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                        <div class="bg-blue-50 p-4 rounded-lg border border-blue-100">
                            <h3 class="text-blue-800 font-medium">Total Input Quantity</h3>
                            <p class="text-2xl font-bold text-blue-900">{{ $totals['total_input'] }}</p>
                        </div>
                        <div class="bg-green-50 p-4 rounded-lg border border-green-100">
                            <h3 class="text-green-800 font-medium">Total Output Quantity</h3>
                            <p class="text-2xl font-bold text-green-900">{{ $totals['total_output'] }}</p>
                        </div>
                        <div class="bg-purple-50 p-4 rounded-lg border border-purple-100">
                            <h3 class="text-purple-800 font-medium">Total Remaining Quantity</h3>
                            <p class="text-2xl font-bold text-purple-900">{{ $totals['total_remaining'] }}</p>
                        </div>
                    </div>

                    <!-- Financial Summary -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                        <div class="bg-yellow-50 p-4 rounded-lg border border-yellow-100">
                            <h3 class="text-yellow-800 font-medium">Total Selling Price</h3>
                            <p class="text-2xl font-bold text-yellow-900">TZS {{ number_format($totals['total_selling_price'], 2) }}</p>
                        </div>
                        <div class="bg-red-50 p-4 rounded-lg border border-red-100">
                            <h3 class="text-red-800 font-medium">Total Profit</h3>
                            <p class="text-2xl font-bold text-red-900">TZS {{ number_format($totals['total_profit'], 2) }}</p>
                        </div>
                    </div>

                    <!-- Products Table -->
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Product</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Input Qty</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Output Qty</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Remaining</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Input Price</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Selling Price</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Profit/Unit</th>
                                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Profit</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                @forelse ($products as $product)
                                    <tr>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ $product['name'] }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ $product['unit'] }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ $product['input_quantity'] }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ $product['output_quantity'] }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">{{ $product['remaining_quantity'] }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">TZS {{ number_format($product['input_price'], 2) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">TZS {{ number_format($product['selling_price'], 2) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">TZS {{ number_format($product['profit_per_unit'], 2) }}</td>
                                        <td class="px-6 py-4 whitespace-nowrap">TZS {{ number_format($product['total_profit'], 2) }}</td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="px-6 py-4 text-center">No products found</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>