<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Edit Stock') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form method="POST" action="{{ route('products.update', $product) }}">
                        @csrf
                        @method('PUT') <!-- Important: Add this for update method -->

                        <div>
                            <x-input-label for="name" :value="__('Product Name')" />
                            <x-text-input id="name" class="block mt-1 w-full" type="text" name="name" 
                                :value="old('name', $product->name)" required autofocus />
                            <x-input-error :messages="$errors->get('name')" class="mt-2" />
                        </div>

                        <!-- Note: Quantity is typically not editable directly in edit forms -->
                        <!-- But kept here since it was in create form -->
                        <div class="mt-4">
                            <x-input-label for="quantity" :value="__('Current Quantity')" />
                            <x-text-input id="quantity" class="block mt-1 w-full bg-gray-100" 
                                type="number" step="0.01" name="quantity" 
                                :value="old('quantity', $product->quantity)" readonly />
                            <p class="text-sm text-gray-500 mt-1">Quantity updated through stock inputs/outputs</p>
                        </div>

                        <div class="mt-4">
                            <x-input-label for="unit" :value="__('Unit')" />
                            <select id="unit" name="unit" class="border-gray-300 focus:border-indigo-500 focus:ring-indigo-500 rounded-md shadow-sm block mt-1 w-full" required>
                                <option value="">Select Unit</option>
                                @foreach(['kg', 'g', 'pieces', 'packages', 'amount', 'boxes'] as $unitOption)
                                    <option value="{{ $unitOption }}" 
                                        {{ old('unit', $product->unit) == $unitOption ? 'selected' : '' }}>
                                        @switch($unitOption)
                                            @case('kg') Kilogram (kg) @break
                                            @case('g') Gram (g) @break
                                            @case('pieces') Pieces @break
                                            @case('packages') Packages @break
                                            @case('amount') Amount @break
                                            @case('boxes') Boxes @break
                                        @endswitch
                                    </option>
                                @endforeach
                            </select>
                            <x-input-error :messages="$errors->get('unit')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="input_price_per_unit" :value="__('Input Price per Unit (Tsh)')" />
                            <x-text-input id="input_price_per_unit" class="block mt-1 w-full" 
                                type="number" step="0.01" name="input_price_per_unit" 
                                :value="old('input_price_per_unit', $product->input_price_per_unit)" required />
                            <x-input-error :messages="$errors->get('input_price_per_unit')" class="mt-2" />
                        </div>

                        <div class="mt-4">
                            <x-input-label for="selling_price_per_unit" :value="__('Selling Price per Unit (Tsh)')" />
                            <x-text-input id="selling_price_per_unit" class="block mt-1 w-full" 
                                type="number" step="0.01" name="selling_price_per_unit" 
                                :value="old('selling_price_per_unit', $product->selling_price_per_unit)" required />
                            <x-input-error :messages="$errors->get('selling_price_per_unit')" class="mt-2" />
                        </div>

                        <div class="flex items-center justify-end mt-4 gap-4">
                            <a href="{{ route('products.index') }}" class="text-gray-600 hover:text-gray-900">
                                {{ __('Cancel') }}
                            </a>
                            <x-primary-button>
                                {{ __('Update Product') }}
                            </x-primary-button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>