<x-app-layout>
    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <h2 class="text-2xl font-semibold mb-6">Add Stock to {{ $product->name }}</h2>
                    
                    <form method="POST" action="{{ route('products.add-stock.store', $product) }}">
                        @csrf
                        
                        <div class="mb-4">
                            <label for="quantity" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Quantity to Add
                            </label>
                            <input type="number" step="0.01" name="quantity" id="quantity" 
                                class="w-full px-3 py-2 border border-gray-300 dark:border-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 dark:bg-gray-700 dark:text-white"
                                required>
                        </div>
                        
                        <div class="mb-4">
                            <label for="input_price_per_unit" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Input Price Per Unit
                            </label>
                            <input type="number" step="0.01" name="input_price_per_unit" id="input_price_per_unit" 
                                value="{{ $product->input_price_per_unit }}"
                                class="w-full px-3 py-2 border border-gray-300 dark:border-gray-700 rounded-md shadow-sm focus:outline-none focus:ring-indigo-500 focus:border-indigo-500 dark:bg-gray-700 dark:text-white"
                                required>
                        </div>
                        
                        <div class="flex items-center justify-end mt-6">
                            <a href="{{ route('products.index') }}" class="mr-4 text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100">
                                Cancel
                            </a>
                            <button type="submit" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500">
                                Add Stock
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>