{{-- resources/views/other_incomes/edit.blade.php --}}

<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Hariri Mapato Mengine') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form action="{{ route('other-incomes.update', $otherIncome->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        <div class="mb-4">
                            <label for="source" class="block text-sm font-medium text-gray-700">Chanzo cha Mapato</label>
                            <select name="source" id="source" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                                <option value="">Chagua Chanzo</option>
                                @foreach ($incomeSources as $source)
                                    <option value="{{ $source }}" {{ (old('source', $otherIncome->source) == $source) ? 'selected' : '' }}>
                                        {{ $source }}
                                    </option>
                                @endforeach
                            </select>
                            @error('source')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Sehemu ya 'Other Description' --}}
                        <div class="mb-4 {{ (old('source', $otherIncome->source) == 'Other') ? '' : 'hidden' }}" id="other_description_div">
                            <label for="description" class="block text-sm font-medium text-gray-700">Maelezo ya Chanzo Kingine</label>
                            <input type="text" name="description" id="description" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" value="{{ old('description', $otherIncome->description) }}">
                            @error('description')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label for="amount" class="block text-sm font-medium text-gray-700">Kiasi (TZS)</label>
                            <input type="number" step="0.01" name="amount" id="amount" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" value="{{ old('amount', $otherIncome->amount) }}" required min="0.01">
                            @error('amount')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label for="income_date" class="block text-sm font-medium text-gray-700">Tarehe ya Mapato</label>
                            <input type="date" name="income_date" id="income_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" value="{{ old('income_date', $otherIncome->income_date) }}" required>
                            @error('income_date')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <a href="{{ route('other-incomes.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest hover:bg-gray-300 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150 mr-2">
                                Batilisha
                            </a>
                            <button type="submit" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:border-indigo-900 focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Sasisha Mapato
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- JavaScript kwa ajili ya kuficha/kuonyesha input ya 'Other Description' --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const sourceSelect = document.getElementById('source');
            const otherDescriptionDiv = document.getElementById('other_description_div');
            const descriptionInput = document.getElementById('description');

            function toggleOtherDescription() {
                if (sourceSelect.value === 'Other') {
                    otherDescriptionDiv.classList.remove('hidden');
                    descriptionInput.setAttribute('required', 'required');
                } else {
                    otherDescriptionDiv.classList.add('hidden');
                    descriptionInput.removeAttribute('required');
                    descriptionInput.value = '';
                }
            }

            toggleOtherDescription();
            sourceSelect.addEventListener('change', toggleOtherDescription);
        });
    </script>
</x-app-layout>