<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Notification Details') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <h3 class="text-2xl font-bold mb-4">{{ $notification->data['type'] }}</h3>
                    <p class="text-lg text-gray-700 dark:text-gray-300 mb-4">{{ $notification->data['message'] ?? 'No Message' }}</p>

                    <hr class="my-4 border-gray-200 dark:border-gray-700">

                    <p class="text-sm text-gray-500">
                        **Sent At:** {{ $notification->created_at->format('M d, Y h:i A') }} ({{ $notification->created_at->diffForHumans() }})
                    </p>
                    <p class="text-sm text-gray-500">
                        **Status:**
                        @if ($notification->read_at)
                            <span class="text-green-500">Read</span> at {{ $notification->read_at->format('M d, Y h:i A') }}
                        @else
                            <span class="text-red-500">Unread</span>
                        @endif
                    </p>

                    @if(isset($notification->data['user_id']))
                        <p class="text-sm text-gray-500 mt-2">
                            **Related User ID:** {{ $notification->data['user_id'] }}
                        </p>
                    @endif

                    <div class="mt-6">
                        <a href="{{ route('notifications.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-200 dark:bg-gray-700 border border-transparent rounded-md font-semibold text-xs text-gray-800 dark:text-gray-200 uppercase tracking-widest hover:bg-gray-300 dark:hover:bg-gray-600 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 dark:focus:ring-offset-gray-800 transition ease-in-out duration-150">
                            {{ __('Back to All Notifications') }}
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>