<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Notifications') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    @forelse ($notifications as $notification)
                        <div class="mb-4 p-4 border rounded-lg {{ $notification->unread() ? 'bg-blue-50 dark:bg-gray-700' : 'bg-white dark:bg-gray-800' }}">
                            <div class="flex justify-between items-start">
                                <div>
                                    <h3 class="font-bold text-gray-900 dark:text-gray-100">{{ $notification->data['title'] ?? 'Notification' }}</h3>
                                    <p class="text-gray-700 dark:text-gray-300">{{ $notification->data['message'] ?? '' }}</p>
                                    <p class="text-sm text-gray-500 mt-1">{{ $notification->created_at->diffForHumans() }}</p>

                                    
                                    <a href="{{ route('notifications.show', $notification->id) }}" class="text-blue-600 hover:underline mt-2 inline-block">
                                        {{ __('View Details') }}
                                    </a>
                                </div>

                                {{-- HAPA NDIYO MABADILIKO YA MARK AS READ BUTTON --}}
                                @if($notification->unread())
                                    <form method="POST" action="{{ route('notifications.markAsRead', $notification->id) }}">
                                        @csrf
                                        @method('PATCH') {{-- Tumia PATCH kwa ajili ya update --}}
                                        <button type="submit" class="text-sm bg-blue-500 text-white px-2 py-1 rounded hover:bg-blue-600 transition duration-150 ease-in-out">
                                            {{ __('Mark as Read') }}
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    @empty
                        <p class="text-gray-700 dark:text-gray-300">{{ __('No notifications found.') }}</p>
                    @endforelse

                    <div class="mt-4">
                        {{ $notifications->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>