<nav x-data="{ open: false }" class="bg-white dark:bg-gray-800 border-b border-gray-100 dark:border-gray-700">
    <div class="max-w-full mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between h-16 items-center">
            <div class="flex items-center">
                <div class="shrink-0 flex items-center">
                    @php
                        $dashboardRoute = 'welcome';
                        if (Auth::check()) {
                            if (Auth::user()->role === 'admin') {
                                $dashboardRoute = 'admin.dashboard';
                            } elseif (Auth::user()->role === 'seller') {
                                $dashboardRoute = 'seller.dashboard';
                            } elseif (Auth::user()->role === 'storekeeper') {
                                $dashboardRoute = 'storekeeper.dashboard';
                            }
                        }
                    @endphp
                    <a href="{{ route($dashboardRoute) }}">
                        <img src="{{ asset('images/CAMON.jpg') }}" alt="{{ config('app.name', 'Laravel') }} Logo" class="block h-20 w-20 rounded-full object-cover">
                    </a>
                </div>

                <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex items-center">
                    @if (Auth::user()->role === 'admin')
                        <x-nav-link :href="route('admin.dashboard')" :active="request()->routeIs('admin.dashboard')">
                            {{ __('Admin Dashboard') }}
                        </x-nav-link>
                    @elseif (Auth::user()->role === 'seller')
                        <x-nav-link :href="route('seller.dashboard')" :active="request()->routeIs('seller.dashboard')">
                            {{ __('Seller Dashboard') }}
                        </x-nav-link>
                    @elseif (Auth::user()->role === 'storekeeper')
                        <x-nav-link :href="route('storekeeper.dashboard')" :active="request()->routeIs('storekeeper.dashboard')">
                            {{ __('Storekeeper Dashboard') }}
                        </x-nav-link>
                    @else
                        <x-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                            {{ __('Dashboard') }}
                        </x-nav-link>
                    @endif

                    @can('sell-stock')
                        @if(Auth::user()->role === 'seller')
                            <x-nav-link :href="route('seller.sales.index')" :active="request()->routeIs('seller.sales.index')">
                                {{ __('My Sales') }}
                            </x-nav-link>
                            <x-nav-link :href="route('seller.stock')" :active="request()->routeIs('seller.stock')">
                                {{ __('Available Stock') }}
                            </x-nav-link>
                            <x-nav-link :href="route('seller.received-stock')" :active="request()->routeIs('seller.received-stock')">
                                {{ __('Received Stock') }}
                            </x-nav-link>
                        @endif
                    @endcan

                    @auth
                        @if(Auth::user()->role === 'admin' || Auth::user()->role === 'storekeeper' || Auth::user()->role === 'seller')
                            <x-nav-link :href="route('stock.overview')" :active="request()->routeIs('stock.overview')">
                                {{ __('Stock Overview') }}
                            </x-nav-link>
                        @endif
                        {{-- **CORRECTED:** Login History Links for Desktop --}}
                        @can('view-my-login-history') {{-- Using the correct Gate --}}
                            <x-nav-link :href="route('my.login.history')" :active="request()->routeIs('my.login.history')">
                                {{ __('My Login History') }}
                            </x-nav-link>
                        @endcan

                        @can('view-all-login-history') {{-- Using the correct Gate --}}
                            <x-nav-link :href="route('admin.login.history')" :active="request()->routeIs('admin.login.history')">
                                {{ __('All Users Login History') }}
                            </x-nav-link>
                        @endcan
                        {{-- END CORRECTED --}}
                    @endauth

                </div>
            </div>

            <div class="hidden sm:flex sm:items-center sm:ms-6">
                <x-dropdown align="right" width="48">
                    <x-slot name="trigger">
                        <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 dark:text-gray-400 bg-white dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none transition ease-in-out duration-150">
                            <div>{{ Auth::user()->name }}</div>
                            <div class="ms-1">
                                <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                </svg>
                            </div>
                        </button>
                    </x-slot>

                    <x-slot name="content">
                        <x-dropdown-link :href="route('profile.edit')">
                            {{ __('Profile') }}
                        </x-dropdown-link>

                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <x-dropdown-link :href="route('logout')"
                                            onclick="event.preventDefault();
                                                        this.closest('form').submit();">
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </form>
                    </x-slot>
                </x-dropdown>
            </div>

            <div class="-me-2 flex items-center sm:hidden">
                <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-900 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-900 focus:text-gray-500 dark:focus:text-gray-400 transition duration-150 ease-in-out">
                    <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                        <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    </div>

    <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
        <div class="pt-2 pb-3 space-y-1">
            @if (Auth::user()->role === 'admin')
                <x-responsive-nav-link :href="route('admin.dashboard')" :active="request()->routeIs('admin.dashboard')">
                    {{ __('Admin Dashboard') }}
                </x-responsive-nav-link>
            @elseif (Auth::user()->role === 'seller')
                <x-responsive-nav-link :href="route('seller.dashboard')" :active="request()->routeIs('seller.dashboard')">
                    {{ __('Seller Dashboard') }}
                </x-responsive-nav-link>

                <x-responsive-nav-link :href="route('seller.sales.index')" :active="request()->routeIs('seller.sales.index')">
                    {{ __('My Sales') }}
                </x-responsive-nav-link>

                <x-responsive-nav-link :href="route('seller.stock')" :active="request()->routeIs('seller.stock')">
                    {{ __('Available Stock') }}
                </x-responsive-nav-link>

                <x-responsive-nav-link :href="route('seller.received-stock')" :active="request()->routeIs('seller.received-stock')">
                    {{ __('Received Stock') }}
                </x-responsive-nav-link>
            @elseif (Auth::user()->role === 'storekeeper')
                <x-responsive-nav-link :href="route('storekeeper.dashboard')" :active="request()->routeIs('storekeeper.dashboard')">
                    {{ __('Storekeeper Dashboard') }}
                </x-responsive-nav-link>
            @else
                <x-responsive-nav-link :href="route('dashboard')" :active="request()->routeIs('dashboard')">
                    {{ __('Dashboard') }}
                </x-responsive-nav-link>
            @endif

            @auth
                @if(Auth::user()->role === 'admin' || Auth::user()->role === 'storekeeper' || Auth::user()->role === 'seller')
                    <x-responsive-nav-link :href="route('stock.overview')" :active="request()->routeIs('stock.overview')">
                        {{ __('Stock Overview') }}
                    </x-responsive-nav-link>
                @endif
                {{-- **CORRECTED:** Login History Links for Responsive Menu --}}
                @can('view-my-login-history') {{-- Using the correct Gate --}}
                    <x-responsive-nav-link :href="route('my.login.history')" :active="request()->routeIs('my.login.history')">
                        {{ __('My Login History') }}
                    </x-responsive-nav-link>
                @endcan

                @can('view-all-login-history') {{-- Using the correct Gate --}}
                    <x-responsive-nav-link :href="route('admin.login.history')" :active="request()->routeIs('admin.login.history')">
                        {{ __('All Users Login History') }}
                    </x-responsive-nav-link>
                @endcan
                {{-- END CORRECTED --}}
            @endauth

        </div>

        <div class="pt-4 pb-1 border-t border-gray-200 dark:border-gray-600">
            <div class="px-4">
                <div class="font-medium text-base text-gray-800 dark:text-gray-200">{{ Auth::user()->name }}</div>
                <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email }}</div>
            </div>

            <div class="mt-3 space-y-1">
                <x-responsive-nav-link :href="route('profile.edit')">
                    {{ __('Profile') }}
                </x-responsive-nav-link>

                <form method="POST" action="{{ route('logout') }}">
                    @csrf
                    <x-responsive-nav-link :href="route('logout')"
                                            onclick="event.preventDefault();
                                                        this.closest('form').submit();">
                        {{ __('Log Out') }}
                    </x-responsive-nav-link>
                </form>
            </div>
        </div>
    </div>
</nav>