<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="icon" href="{{ asset('images/CAMON.jpg') }}" type="image/jpg">

    <title>CMS</title>

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @stack('scripts')
</head>
<script src="https://cdn.tailwindcss.com?plugins=forms,typography,aspect-ratio,line-clamp"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Arial', 'sans-serif'], // Define Arial as the primary sans-serif font
                    }
                }
            }
        }
    </script>
<body class="font-sans antialiased">
    <div class="min-h-screen bg-gray-100 dark:bg-gray-900" x-data="{ sidebarOpen: false, notificationsOpen: false }">

        <nav x-data="{ open: false }" class="bg-yellow-500 dark:bg-yellow-700 border-b border-gray-200 dark:border-gray-700 shadow-sm">
            <div class="max-w-full mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-16">
                    <div class="flex items-center">
                        {{-- LOGO SEHEMU YA KUSHOTO --}}
                        <div class="shrink-0 flex items-center">
                            @php
                                $dashboardRoute = 'welcome';
                                if (Auth::check()) {
                                    if (Auth::user()->role === 'admin') {
                                        $dashboardRoute = 'admin.dashboard';
                                    } elseif (Auth::user()->role === 'storekeeper') {
                                        $dashboardRoute = 'storekeeper.dashboard';
                                    } elseif (Auth::user()->role === 'seller') {
                                        $dashboardRoute = 'seller.dashboard';
                                    }
                                }
                            @endphp
                            <a href="{{ route($dashboardRoute) }}">
                                {{-- Hakikisha 'images/CAMON.jpg' ni path sahihi na picha ipo kwenye public/images --}}
                                <img src="{{ asset('images/CAMON.jpg') }}" alt="CMS Logo" class="block h-16 w-16 rounded-full object-cover">
                            </a>
                        </div>

                        {{-- NAVIGATION LINKS ZA KATI --}}
                        <div class="hidden space-x-8 sm:-my-px sm:ms-10 sm:flex">
                            @auth
                                <x-nav-link :href="route($dashboardRoute)" :active="request()->routeIs($dashboardRoute)" class="text-white hover:text-gray-200 dark:text-gray-200 dark:hover:text-gray-100">
                                    {{ __('Dashboard') }}
                                </x-nav-link>

                                @if(Auth::user()->role === 'admin' || Auth::user()->role === 'storekeeper')
                                    <x-nav-link :href="route('products.index')" :active="request()->routeIs('products.index')" class="text-white hover:text-gray-200 dark:text-gray-200 dark:hover:text-gray-100">
                                        {{ __('Manage Stock') }}
                                    </x-nav-link>

                                    <x-nav-link :href="route('stock-outputs.index')" :active="request()->routeIs('stock-outputs.index')" class="text-white hover:text-gray-200 dark:text-gray-200 dark:hover:text-gray-100">
                                        {{ __('Stock Transfers') }}
                                    </x-nav-link>
                                @endif


                                @if(Auth::user()->role === 'admin' || Auth::user()->role === 'storekeeper' || Auth::user()->role === 'seller')
                                    <x-nav-link :href="route('sales.index')" :active="request()->routeIs('sales.index')" class="text-white hover:text-gray-200 dark:text-gray-200 dark:hover:text-gray-100">
                                        {{ __('Sales') }}
                                    </x-nav-link>
                                @endif

                                @if(Auth::user()->role === 'admin')
                                    <x-nav-link :href="route('users.index')" :active="request()->routeIs('users.index')" class="text-white hover:text-gray-200 dark:text-gray-200 dark:hover:text-gray-100">
                                        {{ __('User Management') }}
                                    </x-nav-link>

                                    <x-nav-link :href="route('admin.login.history')" :active="request()->routeIs('admin.login.history')" class="text-white hover:text-gray-200 dark:text-gray-200 dark:hover:text-gray-100">
                                        {{ __('View All login History') }}
                                    </x-nav-link>
                                @endif

                                @can('sell-stock') {{-- Ikiwa unatumia Gates/Policies --}}
                                    <x-nav-link :href="route('user.login.history')" :active="request()->routeIs('user.login.history')" class="text-white hover:text-gray-200 dark:text-gray-200 dark:hover:text-gray-100">
                                        {{ __('My login History') }}
                                    </x-nav-link>
                                @endcan
                            @endauth
                        </div>
                    </div>

                    {{-- Notifications na PROFILE DROPDOWN (PICHA NA JINA) --}}
                    <div class="hidden sm:flex sm:items-center sm:ms-6">
                        @auth
                            {{-- Picha ya Mtumiaji na Profile Dropdown kwanza --}}
                            <div class="me-2">
                                {{-- Tumia profile_photo_url accessor kutoka User model --}}
                                {{-- HII IMEBADILISHWA: h-10 w-10 badala ya h-8 w-8 --}}
                                <img class="h-10 w-10 rounded-full object-cover" src="{{ Auth::user()->profile_photo_url }}" alt="{{ Auth::user()->name }}" />
                            </div>

                            <x-dropdown align="right" width="48">
                                <x-slot name="trigger">
                                    <button class="inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 dark:text-gray-400 bg-white dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none transition ease-in-out duration-150">
                                        <div>{{ Auth::user()->name ?? 'Guest' }}</div>
                                        <div class="ms-1">
                                            <svg class="fill-current h-4 w-4" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20">
                                                <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                                            </svg>
                                        </div>
                                    </button>
                                </x-slot>

                                <x-slot name="content">
                                    <x-dropdown-link :href="route('profile.edit')">
                                        {{ __('Profile') }}
                                    </x-dropdown-link>

                                    <form method="POST" action="{{ route('logout') }}" id="logout-form-dropdown">
                                        @csrf
                                        <x-dropdown-link :href="route('logout')"
                                                            onclick="event.preventDefault();
                                                                    this.closest('form').submit();">
                                            {{ __('Log Out') }}
                                        </x-dropdown-link>
                                    </form>
                                </x-slot>
                            </x-dropdown>

                            <div class="relative ms-4" x-data="{ open: false }" @click.outside="open = false">
                                <button @click="open = !open" class="relative inline-flex items-center px-3 py-2 border border-transparent text-sm leading-4 font-medium rounded-md text-gray-500 dark:text-gray-400 bg-white dark:bg-gray-800 hover:text-gray-700 dark:hover:text-gray-300 focus:outline-none transition ease-in-out duration-150">
                                    <svg class="h-5 w-5" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                                    </svg>
                                    @if(Auth::user()->unreadNotifications->count() > 0)
                                        <span class="absolute top-0 right-0 inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-red-100 bg-red-600 rounded-full transform translate-x-1/2 -translate-y-1/2">
                                            {{ Auth::user()->unreadNotifications->count() }}
                                        </span>
                                    @endif
                                </button>

                                <div x-show="open" x-transition:enter="transition ease-out duration-200" x-transition:enter-start="transform opacity-0 scale-95" x-transition:enter-end="transform opacity-100 scale-100" x-transition:leave="transition ease-in duration-75" x-transition:leave-start="transform opacity-100 scale-100" x-transition:leave-end="transform opacity-0 scale-95" class="absolute z-50 mt-2 w-72 rounded-md shadow-lg origin-top-right right-0" style="display: none;">
                                    <div class="rounded-md ring-1 ring-black ring-opacity-5 py-1 bg-white dark:bg-gray-700">
                                        <div class="block px-4 py-2 text-xs text-gray-400">
                                            {{ __('Notifications') }}
                                        </div>

                                        @forelse (Auth::user()->unreadNotifications as $notification)
                                            <a href="{{ route('notifications.show', $notification->id) }}" class="block w-full px-4 py-2 text-start text-sm leading-5 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-800 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-800 transition duration-150 ease-in-out">
                                                <p class="font-semibold">{{ $notification->data['title'] ?? 'Notification' }}</p>
                                                <p class="text-xs text-gray-500">{{ $notification->data['message'] ?? 'New notification' }}</p>
                                                <p class="text-xs text-gray-500">{{ $notification->created_at->diffForHumans() }}</p>
                                            </a>
                                        @empty
                                            <div class="block px-4 py-2 text-sm text-gray-700 dark:text-gray-200">
                                                {{ __('No New Notifications') }}
                                            </div>
                                        @endforelse

                                        @if(Auth::user()->unreadNotifications->count() > 0)
                                            <div class="border-t border-gray-200 dark:border-gray-600"></div>
                                            <form method="POST" action="{{ route('notifications.markAllAsRead') }}">
                                                @csrf
                                                <button type="submit" class="block w-full text-left px-4 py-2 text-sm leading-5 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-800 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-800 transition duration-150 ease-in-out">
                                                    {{ __('Read All') }}
                                                </button>
                                            </form>
                                        @endif
                                        <a href="{{ route('notifications.index') }}" class="block w-full px-4 py-2 text-start text-sm leading-5 text-gray-700 dark:text-gray-200 hover:bg-gray-100 dark:hover:bg-gray-800 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-800 transition duration-150 ease-in-out">
                                            {{ __('View All Notifications') }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endauth
                    </div>

                    {{-- MOBILE MENU BUTTON --}}
                    <div class="-me-2 flex items-center sm:hidden">
                        <button @click="open = ! open" class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 dark:text-gray-500 hover:text-gray-500 dark:hover:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-900 focus:outline-none focus:bg-gray-100 dark:focus:bg-gray-900 focus:text-gray-500 dark:focus:text-gray-400 transition duration-150 ease-in-out">
                            <svg class="h-6 w-6" stroke="currentColor" fill="none" viewBox="0 0 24 24">
                                <path :class="{'hidden': open, 'inline-flex': ! open }" class="inline-flex" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                                <path :class="{'hidden': ! open, 'inline-flex': open }" class="hidden" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>
                </div>
            </div>

            {{-- RESPONSIVE NAVIGATION MENU (MOBILE) --}}
            <div :class="{'block': open, 'hidden': ! open}" class="hidden sm:hidden">
                <div class="pt-2 pb-3 space-y-1">
                    @auth
                        <x-responsive-nav-link :href="route($dashboardRoute)" :active="request()->routeIs($dashboardRoute)">
                            {{ __('Dashboard') }}
                        </x-responsive-nav-link>

                        @if(Auth::user()->role === 'admin' || Auth::user()->role === 'storekeeper')
                            <x-responsive-nav-link :href="route('products.index')" :active="request()->routeIs('products.index')">
                                {{ __('Manage Stock') }}
                            </x-responsive-nav-link>

                            <x-responsive-nav-link :href="route('stock-outputs.index')" :active="request()->routeIs('stock-outputs.index')">
                                {{ __('Stock Transfers') }}
                            </x-responsive-nav-link>
                        @endif

                        @if(Auth::user()->role === 'admin' || Auth::user()->role === 'storekeeper' || Auth::user()->role === 'seller')
                            <x-responsive-nav-link :href="route('sales.index')" :active="request()->routeIs('sales.index')">
                                {{ __('Sales') }}
                            </x-responsive-nav-link>
                        @endif

                        @if(Auth::user()->role === 'admin')
                            <x-responsive-nav-link :href="route('users.index')" :active="request()->routeIs('users.index')">
                                {{ __('User Management') }}
                            </x-responsive-nav-link>
                            <x-responsive-nav-link :href="route('admin.login.history')" :active="request()->routeIs('admin.login.history')">
                                {{ __('View All login History') }}
                            </x-responsive-nav-link>
                        @endif
                        @can('sell-stock')
                            <x-responsive-nav-link :href="route('user.login.history')" :active="request()->routeIs('user.login.history')">
                                {{ __('My login History') }}
                            </x-responsive-nav-link>
                        @endcan

                        {{-- Mobile Notifications Link --}}
                        <div class="relative px-4 py-2 border-t border-gray-200 dark:border-gray-600">
                            <a href="{{ route('notifications.index') }}" class="flex items-center text-gray-700 dark:text-gray-200 hover:text-gray-900 dark:hover:text-gray-100 transition duration-150 ease-in-out">
                                <svg class="h-5 w-5 me-2" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9" />
                                </svg>
                                {{ __('Notifications') }}
                                @if(Auth::user()->unreadNotifications->count() > 0)
                                    <span class="ms-auto inline-flex items-center justify-center px-2 py-1 text-xs font-bold leading-none text-red-100 bg-red-600 rounded-full">
                                        {{ Auth::user()->unreadNotifications->count() }}
                                    </span>
                                @endif
                            </a>
                        </div>

                    @endauth
                </div>

                <div class="pt-4 pb-1 border-t border-gray-200 dark:border-gray-600">
                    {{-- Profile information for mobile responsive menu --}}
                    <div class="flex items-center px-4">
                        <div class="shrink-0 me-3">
                            @auth
                                {{-- HII IMEBADILISHWA: h-12 w-12 badala ya h-10 w-10 --}}
                                <img class="h-12 w-12 rounded-full object-cover" src="{{ Auth::user()->profile_photo_url }}" alt="{{ Auth::user()->name }}" />
                            @else
                                {{-- HII IMEBADILISHWA: h-12 w-12 badala ya h-10 w-10 --}}
                                <svg class="h-12 w-12 text-gray-400" fill="currentColor" viewBox="0 0 24 24">
                                    <path fill-rule="evenodd" d="M18.638 10.977C18.638 7.715 15.923 5 12.66 5h-.32c-3.263 0-5.978 2.715-5.978 5.977 0 1.12.316 2.194.876 3.08.06.098.12.193.18.29l1.186 2.372c.24.48.72.8 1.28.8h6c.56 0 1.04-.32 1.28-.8l1.185-2.372c.06-.097.12-.192.18-.29.56-.885.877-1.96.877-3.08zm-7.276 1.023a2 2 0 10-4 0 2 2 0 004 0z" clip-rule="evenodd" />
                                </svg>
                            @endauth
                        </div>
                        <div>
                            <div class="font-medium text-base text-gray-800 dark:text-gray-200">{{ Auth::user()->name ?? 'Guest' }}</div>
                            <div class="font-medium text-sm text-gray-500">{{ Auth::user()->email ?? 'guest@example.com' }}</div>
                        </div>
                    </div>

                    <div class="mt-3 space-y-1">
                        @auth
                            <x-responsive-nav-link :href="route('profile.edit')">
                                {{ __('Profile') }}
                            </x-responsive-nav-link>

                            <form method="POST" action="{{ route('logout') }}" id="logout-form-responsive">
                                @csrf
                                <x-responsive-nav-link :href="route('logout')"
                                                            onclick="event.preventDefault();
                                                                    this.closest('form').submit();">
                                    {{ __('Log Out') }}
                                </x-responsive-nav-link>
                            </form>
                        @else
                            <x-responsive-nav-link :href="route('login')">
                                {{ __('Log In') }}
                            </x-responsive-nav-link>
                            @if (Route::has('register'))
                                <x-responsive-nav-link :href="route('register')">
                                    {{ __('Register') }}
                                </x-responsive-nav-link>
                            @endif
                        @endauth
                    </div>
                </div>
            </div>
        </nav>

        <div class="flex flex-1">
            <aside :class="{'block': sidebarOpen, 'hidden': !sidebarOpen}" class="md:block w-80 bg-white dark:bg-gray-800 shadow-md border-r border-gray-200 dark:border-gray-700 h-[calc(100vh-4rem)] md:h-auto fixed md:relative z-50 md:z-auto">
                <div class="p-4 border-b border-gray-200 dark:border-gray-700 md:hidden">
                    <h2 class="text-lg font-semibold text-gray-800 dark:text-gray-200">Stock Summary</h2>
                    <button @click="sidebarOpen = false" class="absolute top-4 right-4 p-2 rounded-md text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 shadow-md">
                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
                <div class="p-4 border-b border-gray-200 dark:border-gray-700 hidden md:block">
                    <h2 class="text-lg font-semibold text-gray-800 dark:text-gray-200">Stock Summary</h2>
                </div>
                <div class="overflow-y-auto h-[calc(100vh-8rem)] md:h-[calc(100vh-4rem)]">
                    @auth
                        @if(Auth::user()->role === 'admin' || Auth::user()->role === 'storekeeper')
                            <div class="p-4">
                                <h3 class="text-sm font-medium text-gray-500 dark:text-gray-400 uppercase tracking-wider mb-2">Remaining Stock</h3>
                                <ul class="space-y-2">
                                   @foreach(App\Models\Product::where('user_id', Auth::id())
                                   ->with(['stockInputs', 'stockOutputs'])
                                   ->get() as $product)
                                <li class="flex items-center justify-between py-2 px-3 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-md">
                                    <a href="{{ route('products.show', $product->id) }}"
                                       class="flex-grow flex items-center text-sm font-medium text-gray-700 dark:text-gray-300">
                                        <span class="truncate">{{ $product->name }}</span>
                                        <span class="ml-2 bg-blue-100 dark:bg-blue-900 text-blue-800 dark:text-blue-100 text-xs px-2 py-1 rounded-full">
                                            {{ $product->quantity }} {{ $product->unit }} remaining
                                        </span>
                                    </a>
                                    <a href="{{ route('products.add-stock.create', $product) }}"
                                       class="ml-4 bg-green-500 hover:bg-green-600 text-white text-xs px-2 py-1 rounded-md transition ease-in-out duration-150">
                                        Add
                                    </a>
                                </li>
                                @endforeach
                                </ul>
                            </div>
                        @endif
                    @endauth
                </div>
            </aside>

            <div x-show="sidebarOpen" @click="sidebarOpen = false" class="md:hidden fixed inset-0 bg-gray-600 bg-opacity-75 z-40"></div>

            <div class="flex-1 flex flex-col">
                <div class="md:hidden p-4">
                    <button @click="sidebarOpen = !sidebarOpen" class="p-2 rounded-md text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-800 shadow-md">
                        <svg class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                </div>

                @if (isset($header))
                    <header class="bg-white dark:bg-gray-800 shadow">
                        <div class="max-w-full mx-auto py-6 px-4 sm:px-6 lg:px-8">
                            {{ $header }}
                        </div>
                    </header>
                @endif

                <main class="flex-1">
                    {{ $slot }}
                </main>
            </div>
        </div>
    </div>
    <script>
    let logoutTimer;
    const logoutTime = 5 * 60 * 1000; // Dakika 5 katika millisekunde

    function resetTimer() {
        clearTimeout(logoutTimer);
        logoutTimer = setTimeout(() => {
            alert('Umekaa kimya kwa muda mrefu. Tafadhali ingia tena.'); // Ujumbe wa kumwambia a-login

            // Find the logout form and submit it
            const logoutForm = document.getElementById('logout-form-dropdown'); // Use the ID from your existing form
            if (logoutForm) {
                logoutForm.submit();
            } else {
                // Fallback if the form isn't found (though it should be if a user is logged in)
                console.error("Logout form not found for idle timeout. Redirecting via GET (less secure).");
                window.location.href = '{{ route('logout') }}';
            }
        }, logoutTime);
    }

    // Rudisha timer kila mtumiaji anapofanya kitu
    document.addEventListener('mousemove', resetTimer);
    document.addEventListener('keypress', resetTimer);
    document.addEventListener('scroll', resetTimer);
    document.addEventListener('click', resetTimer);

    // Anzisha timer mara ya kwanza ukurasa unapojaa
    resetTimer();

    // Kinga dhidi ya cache ya browser:
    window.addEventListener('pageshow', function (event) {
        if (event.persisted) {
            // Ukurasa unarejeshwa kutoka cache ya "back-forward"
            window.location.reload();
        }
    });
</script>
</body>
</html>