<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Fixed Assets Management') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100">
                    <div class="flex justify-between mb-4">
                        <h3 class="text-lg font-semibold">List of Fixed Assets</h3>
                        <a href="{{ route('fixed-assets.create') }}" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                            Add New Asset
                        </a>
                    </div>

                    <div class="overflow-x-auto">
                        <table class="min-w-full bg-white dark:bg-gray-700">
                            <thead>
                                <tr>
                                    <th class="py-2 px-4 border-b border-gray-200 dark:border-gray-600">Name</th>
                                    <th class="py-2 px-4 border-b border-gray-200 dark:border-gray-600">Category</th>
                                    <th class="py-2 px-4 border-b border-gray-200 dark:border-gray-600">Purchase Date</th>
                                    <th class="py-2 px-4 border-b border-gray-200 dark:border-gray-600">Purchase Cost</th>
                                    <th class="py-2 px-4 border-b border-gray-200 dark:border-gray-600">Current Value</th>
                                    <th class="py-2 px-4 border-b border-gray-200 dark:border-gray-600">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($assets as $asset)
                                <tr>
                                    <td class="py-2 px-4 border-b border-gray-200 dark:border-gray-600">{{ $asset->name }}</td>
                                    <td class="py-2 px-4 border-b border-gray-200 dark:border-gray-600">{{ $asset->category }}</td>
                                    <td class="py-2 px-4 border-b border-gray-200 dark:border-gray-600">{{ $asset->purchase_date->format('d/m/Y') }}</td>
                                    <td class="py-2 px-4 border-b border-gray-200 dark:border-gray-600 text-right">{{ number_format($asset->purchase_cost, 2) }} TZS</td>
                                    <td class="py-2 px-4 border-b border-gray-200 dark:border-gray-600 text-right">{{ number_format($asset->current_value, 2) }} TZS</td>
                                    <td class="py-2 px-4 border-b border-gray-200 dark:border-gray-600">
                                        <a href="{{ route('fixed-assets.edit', $asset->id) }}" class="text-blue-500 hover:text-blue-700">Edit</a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>