{{-- resources/views/expenses/edit.blade.php --}}

<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            {{ __('Hariri Matumizi') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900">
                    <form action="{{ route('expenses.update', $expense->id) }}" method="POST">
                        @csrf
                        @method('PUT')

                        {{-- Mpya: Kategoria ya Matumizi --}}
                        <div class="mb-4">
                            <label for="category_name" class="block text-sm font-medium text-gray-700">Kategoria ya Matumizi</label>
                            <select name="category_name" id="category_name" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" required>
                                <option value="">Chagua Kategoria</option>
                                @foreach ($expenseCategories as $category)
                                    <option value="{{ $category }}" {{ (old('category_name', $expense->category_name) == $category) ? 'selected' : '' }}>
                                        {{ $category }}
                                    </option>
                                @endforeach
                            </select>
                            @error('category_name')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        {{-- Mpya: Sehemu ya 'Other Category Description' --}}
                        <div class="mb-4 {{ (old('category_name', $expense->category_name) == 'Others') ? '' : 'hidden' }}" id="other_details_div">
                            <label for="other_details" class="block text-sm font-medium text-gray-700">Maelezo ya Kategoria Nyingine</label>
                            <input type="text" name="other_details" id="other_details" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" value="{{ old('other_details', $expense->other_details) }}">
                            @error('other_details')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        {{-- Hii sasa ni kwa maelezo ya ziada ya expense (original description field) --}}
                        <div class="mb-4">
                            <label for="description" class="block text-sm font-medium text-gray-700">Maelezo ya Ziada (Optional)</label>
                            <input type="text" name="description" id="description" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" value="{{ old('description', $expense->description) }}">
                            @error('description')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label for="amount" class="block text-sm font-medium text-gray-700">Kiasi (TZS)</label>
                            <input type="number" step="0.01" name="amount" id="amount" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" value="{{ old('amount', $expense->amount) }}" required min="0.01">
                            @error('amount')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="mb-4">
                            <label for="expense_date" class="block text-sm font-medium text-gray-700">Tarehe ya Matumizi</label>
                            <input type="date" name="expense_date" id="expense_date" class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-300 focus:ring focus:ring-indigo-200 focus:ring-opacity-50" value="{{ old('expense_date', $expense->expense_date) }}" required>
                            @error('expense_date')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="flex items-center justify-end mt-4">
                            <a href="{{ route('expenses.index') }}" class="inline-flex items-center px-4 py-2 bg-gray-200 border border-transparent rounded-md font-semibold text-xs text-gray-700 uppercase tracking-widest hover:bg-gray-300 focus:outline-none focus:border-gray-900 focus:ring ring-gray-300 disabled:opacity-25 transition ease-in-out duration-150 mr-2">
                                Batilisha
                            </a>
                            <button type="submit" class="inline-flex items-center px-4 py-2 bg-indigo-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-indigo-700 active:bg-indigo-900 focus:outline-none focus:border-indigo-900 focus:ring ring-indigo-300 disabled:opacity-25 transition ease-in-out duration-150">
                                Sasisha Matumizi
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- JavaScript kwa ajili ya kuficha/kuonyesha input ya 'Other Details' --}}
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const categoryNameSelect = document.getElementById('category_name');
            const otherDetailsDiv = document.getElementById('other_details_div');
            const otherDetailsInput = document.getElementById('other_details');

            function toggleOtherDetails() {
                if (categoryNameSelect.value === 'Others') {
                    otherDetailsDiv.classList.remove('hidden');
                    otherDetailsInput.setAttribute('required', 'required');
                } else {
                    otherDetailsDiv.classList.add('hidden');
                    otherDetailsInput.removeAttribute('required');
                    otherDetailsInput.value = '';
                }
            }

            toggleOtherDetails();
            categoryNameSelect.addEventListener('change', toggleOtherDetails);
        });
    </script>
</x-app-layout>