<x-guest-layout>
    <nav class="w-full fixed top-0 left-0 right-0 bg-yellow-500 py-5 shadow-lg z-50">
        <div class="container mx-auto px-4 flex justify-between items-center max-w-6xl">
            <div class="text-white font-bold text-2xl">Camon Management System</div>
            <div class="flex space-x-6">
                @auth
                    <span class="text-white text-lg">Welcome, {{ Auth::user()->name }}</span>
                @else
                    <a href="{{ route('login') }}" class="text-white hover:text-gray-200 transition-colors text-lg">
                        Login
                    </a>
                @endauth
            </div>
        </div>
    </nav>


        <h1 class="text-3xl font-bold text-center text-gray-800 mb-6">
            Register New User
        </h1>

        <form method="POST" action="{{ route('users.store') }}" class="w-full space-y-6" enctype="multipart/form-data">
    @csrf

    <div>
        <x-input-label for="name" :value="__('Name')" />
        <x-text-input
            id="name"
            class="block mt-1 w-full rounded-lg border-gray-300 focus:border-[#9B870C] focus:ring focus:ring-[#9B870C] focus:ring-opacity-50"
            type="text"
            name="name"
            :value="old('name')"
            required
            autofocus
            autocomplete="name"
        />
        <x-input-error :messages="$errors->get('name')" class="mt-2" />
    </div>

    <div>
        <x-input-label for="email" :value="__('Email')" />
        <x-text-input
            id="email"
            class="block mt-1 w-full rounded-lg border-gray-300 focus:border-[#9B870C] focus:ring focus:ring-[#9B870C] focus:ring-opacity-50"
            type="email"
            name="email"
            :value="old('email')"
            required
            autocomplete="username"
        />
        <x-input-error :messages="$errors->get('email')" class="mt-2" />
    </div>

    {{-- HAPA NDIPO PAMEONGEZWA ENCTYPE="MULTIPART/FORM-DATA" --}}
    <div class="mt-4">
        <x-input-label for="profile_photo" :value="__('Profile Photo')" />
        {{-- Nimeongeza pia 'accept' attribute kwa ajili ya user experience bora --}}
        <input id="profile_photo" class="block mt-1 w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400" type="file" name="profile_photo" accept="image/png, image/jpeg, image/jpg, image/gif">
        <p class="mt-1 text-sm text-gray-500 dark:text-gray-300" id="file_input_help">PNG, JPG or JPEG (MAX. 2MB).</p>
        <x-input-error :messages="$errors->get('profile_photo')" class="mt-2" />
    </div>

    <div>
        <x-input-label for="password" :value="__('Password')" />
        <x-text-input
            id="password"
            class="block mt-1 w-full rounded-lg border-gray-300 focus:border-[#9B870C] focus:ring focus:ring-[#9B870C] focus:ring-opacity-50"
            type="password"
            name="password"
            required
            autocomplete="new-password"
        />
        <x-input-error :messages="$errors->get('password')" class="mt-2" />
    </div>

    <div>
        <x-input-label for="password_confirmation" :value="__('Confirm Password')" />
        <x-text-input
            id="password_confirmation"
            class="block mt-1 w-full rounded-lg border-gray-300 focus:border-[#9B870C] focus:ring focus:ring-[#9B870C] focus:ring-opacity-50"
            type="password"
            name="password_confirmation"
            required
            autocomplete="new-password"
        />
        <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
    </div>

    <div>
        <x-input-label for="role" :value="__('Role')" />
        <select
            id="role"
            class="block mt-1 w-full rounded-lg border-gray-300 focus:border-[#9B870C] focus:ring focus:ring-[#9B870C] focus:ring-opacity-50"
            name="role"
            required
        >
            <option value="seller" {{ old('role') == 'seller' ? 'selected' : '' }}>Seller</option>
            <option value="storekeeper" {{ old('role') == 'storekeeper' ? 'selected' : '' }}>Storekeeper</option>
            <option value="cleaner" {{ old('role') == 'cleaner' ? 'selected' : '' }}>Cleaner</option>
            <option value="staff" {{ old('role') == 'staff' ? 'selected' : '' }}>Other Staff</option>
        </select>
        <x-input-error :messages="$errors->get('role')" class="mt-2" />
    </div>

    <div class="flex items-center justify-end mt-4">
        <a class="underline text-sm text-gray-600 dark:text-gray-400 hover:text-[#9B870C] dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-[#9B870C] dark:focus:ring-offset-gray-800" href="{{ route('login') }}">
            {{ __('Already registered?') }}
        </a>
        <x-primary-button class="ms-4 justify-center bg-[#9B870C] hover:bg-[#7a6d0a] focus:bg-[#7a6d0a] active:bg-[#7a6d0a] transition-colors duration-300 py-3 text-lg">
            {{ __('Register') }}
        </x-primary-button>
    </div>
</form>
    </div>

    <footer class="w-full fixed bottom-0 left-0 right-0 bg-black text-white py-5">
        <div class="container mx-auto px-4 text-center max-w-6xl">
            <p class="text-lg">&copy; {{ date('Y') }} Camon Management System. All rights reserved.</p>
        </div>
    </footer>
</x-guest-layout>