<x-guest-layout>
    <!-- Wider Dark Yellow Navigation -->
    <nav class="w-full fixed top-0 left-0 right-0 bg-yellow-500 py-5 shadow-lg z-50">
        <div class="container mx-auto px-4 flex justify-between items-center max-w-6xl">
            <div class="text-white font-bold text-2xl">Camon Management</div>
            <div class="flex space-x-6">
                @auth
                    <span class="text-white text-lg">Welcome, {{ Auth::user()->name }}</span>
                @else
                    <a href="{{ route('login') }}" class="text-white hover:text-gray-200 transition-colors text-lg">
                        Login
                    </a>
                @endauth
            </div>
        </div>
    </nav>

    <!-- Main Content Container -->
    <div class="flex flex-col items-center space-y-8 w-full max-w-md mx-auto pt-18 pb-24 px-4">
        <!-- Centered Logo -->
        <img src="{{ asset('images/CAMON.jpg') }}" 
             alt="Camon Logo" 
             class="w-32 h-32 animate-logo-float transition-transform duration-300 hover:scale-110">

        <!-- System Name -->
        <h1 class="text-3xl font-bold text-center text-gray-800 mb-6">
            Camon Management System
        </h1>

        <!-- Session Status -->
        <x-auth-session-status class="mb-4 w-full" :status="session('status')" />

        <form method="POST" action="{{ route('login') }}" class="w-full space-y-6">
            @csrf

            <!-- Email Input -->
            <div>
                <x-input-label for="email" :value="__('Email')" />
                <x-text-input 
                    id="email" 
                    class="block mt-1 w-full rounded-lg border-gray-300 focus:border-[#9B870C] focus:ring focus:ring-[#9B870C] focus:ring-opacity-50" 
                    type="email" 
                    name="email" 
                    :value="old('email')" 
                    required 
                    autofocus 
                    autocomplete="username" 
                />
                <x-input-error :messages="$errors->get('email')" class="mt-2" />
            </div>

            <!-- Password Input -->
            <div>
                <x-input-label for="password" :value="__('Password')" />
                <x-text-input 
                    id="password" 
                    class="block mt-1 w-full rounded-lg border-gray-300 focus:border-[#9B870C] focus:ring focus:ring-[#9B870C] focus:ring-opacity-50"
                    type="password"
                    name="password"
                    required 
                    autocomplete="current-password" 
                />
                <x-input-error :messages="$errors->get('password')" class="mt-2" />
            </div>

            <!-- Remember Me & Forgot Password -->
            <div class="flex items-center justify-between">
                <label for="remember_me" class="inline-flex items-center">
                    <input 
                        id="remember_me" 
                        type="checkbox" 
                        class="rounded border-gray-300 text-[#9B870C] shadow-sm focus:ring-[#9B870C]" 
                        name="remember"
                    >
                    <span class="ms-2 text-sm text-gray-600">{{ __('Remember me') }}</span>
                </label>

                @if (Route::has('password.request'))
                    <a class="text-sm text-[#9B870C] hover:text-[#7a6d0a] underline" href="{{ route('password.request') }}">
                        {{ __('Forgot Password?') }}
                    </a>
                @endif
            </div>

            <!-- Login Button -->
            <div class="w-full">
                <x-primary-button class="w-full justify-center bg-[#9B870C] hover:bg-[#7a6d0a] focus:bg-[#7a6d0a] active:bg-[#7a6d0a] transition-colors duration-300 py-3 text-lg">
                    {{ __('Log in') }}
                </x-primary-button>
            </div>
        </form>
    </div>

    <!-- Wider Black Footer -->
    <footer class="w-full fixed bottom-0 left-0 right-0 bg-black text-white py-5">
        <div class="container mx-auto px-4 text-center max-w-6xl">
            <p class="text-lg">&copy; {{ date('Y') }} Camon Management System. All rights reserved.</p>
        </div>
    </footer>
</x-guest-layout>