<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Edit User') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-md mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-sm sm:rounded-lg p-6">
                {{-- MUHIMU: Ongeza enctype="multipart/form-data" --}}
                <form method="POST" action="{{ route('users.update', $user->id) }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT') {{-- Nimeacha PUT kama ulivyoweka, lakini PATCH inapendekezwa kwa updates --}}

                    <div class="mb-4">
                        <x-input-label for="name" :value="__('Name')" />
                        <x-text-input id="name" class="block mt-1 w-full" type="text" name="name" :value="old('name', $user->name)" required autofocus />
                        <x-input-error :messages="$errors->get('name')" class="mt-2" />
                    </div>

                    <div class="mb-4">
                        <x-input-label for="email" :value="__('Email')" />
                        <x-text-input id="email" class="block mt-1 w-full" type="email" name="email" :value="old('email', $user->email)" required />
                        <x-input-error :messages="$errors->get('email')" class="mt-2" />
                    </div>

                    <div class="mb-4">
                        <x-input-label for="role" :value="__('Role')" />
                        <select id="role" name="role" class="block mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-yellow-500 focus:ring-yellow-500 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                            {{-- Hakikisha $roles inatoka kwenye controller yako --}}
                            @foreach($roles as $value => $label)
                                <option value="{{ $value }}" {{ old('role', $user->role) === $value ? 'selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                        <x-input-error :messages="$errors->get('role')" class="mt-2" />
                    </div>

                    ---

                    {{-- NEW: Current Profile Photo --}}
                    <div class="mb-4">
                        <x-input-label :value="__('Current Profile Photo')" />
                        <div class="mt-2">
                            {{-- Tumia accessor ya profile_photo_url kutoka kwenye User model --}}
                            <img src="{{ $user->profile_photo_url }}" alt="{{ $user->name }}" class="h-24 w-24 rounded-full object-cover border border-gray-300 dark:border-gray-600 shadow-sm">
                        </div>
                    </div>

                    {{-- NEW: New Profile Photo Upload --}}
                    <div class="mb-4">
                        <x-input-label for="profile_photo" :value="__('Upload New Profile Photo')" />
                        <input id="profile_photo" class="block mt-1 w-full text-sm text-gray-900 border border-gray-300 rounded-lg cursor-pointer bg-gray-50 dark:text-gray-400 focus:outline-none dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400" type="file" name="profile_photo">
                        <p class="mt-1 text-sm text-gray-500 dark:text-gray-300" id="file_input_help">PNG, JPG au JPEG (MAX. 2MB). Ita-replace picha iliyopo.</p>
                        <x-input-error :messages="$errors->get('profile_photo')" class="mt-2" />
                    </div>

                    {{-- NEW: Option to remove current photo (optional) --}}
                    <div class="mb-4">
                        <input type="checkbox" id="remove_profile_photo" name="remove_profile_photo" value="1" class="rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-yellow-600 shadow-sm focus:ring-yellow-500">
                        <label for="remove_profile_photo" class="ml-2 text-sm text-gray-600 dark:text-gray-400">
                            {{ __('Remove Current Profile Photo') }}
                        </label>
                    </div>

                    ---

                    <div class="mb-4">
                        <x-input-label for="password" :value="__('New Password (leave blank to keep current)')" />
                        <x-text-input id="password" class="block mt-1 w-full" type="password" name="password" autocomplete="new-password" />
                        <x-input-error :messages="$errors->get('password')" class="mt-2" />
                    </div>

                    <div class="mb-4">
                        <x-input-label for="password_confirmation" :value="__('Confirm New Password')" />
                        <x-text-input id="password_confirmation" class="block mt-1 w-full" type="password" name="password_confirmation" />
                        <x-input-error :messages="$errors->get('password_confirmation')" class="mt-2" />
                    </div>

                    <div class="flex items-center justify-end">
                        <x-primary-button class="ml-4">
                            {{ __('Update') }}
                        </x-primary-button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>