<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('User Details') }}
        </h2>
    </x-slot>

    <div class="py-6">
        <div class="max-w-screen-lg mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-gray-800 overflow-hidden shadow-xl sm:rounded-lg p-6">
                <!-- User Profile Header -->
                <div class="flex flex-col md:flex-row gap-6 mb-8">
                    <div class="flex-shrink-0">
                        <div class="h-24 w-24 rounded-full bg-yellow-100 dark:bg-yellow-900 flex items-center justify-center text-3xl font-bold text-yellow-600 dark:text-yellow-300">
                            {{ strtoupper(substr($user->name, 0, 1)) }}
                        </div>
                    </div>
                    <div class="flex-1">
                        <h1 class="text-2xl font-bold text-gray-800 dark:text-white">{{ $user->name }}</h1>
                        <p class="text-gray-600 dark:text-gray-300">{{ $user->email }}</p>
                        <div class="mt-2">
                            <span class="px-3 py-1 inline-flex text-sm leading-5 font-semibold rounded-full
                                {{ $user->role === 'admin' ? 'bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-200' :
                                   ($user->role === 'storekeeper' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200' :
                                   ($user->role === 'seller' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' :
                                   ($user->role === 'cleaner' ? 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200' : 'bg-gray-100 text-gray-800 dark:bg-gray-700 dark:text-gray-200'))) }}">
                                {{ ucfirst($user->role) }}
                            </span>
                        </div>
                    </div>
                    <div class="bg-yellow-50 dark:bg-gray-700 p-4 rounded-lg">
                        <h3 class="text-sm font-medium text-gray-500 dark:text-gray-300">Total Profit Generated</h3>
                        <p class="text-2xl font-bold text-yellow-600 dark:text-yellow-400">{{ number_format($totalProfit, 2) }}</p>
                    </div>
                </div>

                <!-- Stats Cards -->
                <div class="grid grid-cols-1 md:grid-cols-5 gap-4 mb-8" x-data="tabs">
                    <a href="#products" @click.prevent="changeTab('products')"
                       class="p-4 rounded-lg shadow transition-all duration-300 cursor-pointer border stats-card"
                       :class="{
                           'bg-yellow-500 dark:bg-yellow-800 border-yellow-500': activeTab === 'products',
                           'bg-white dark:bg-gray-700 border-gray-200 dark:border-gray-600 hover:bg-yellow-500 dark:hover:bg-yellow-800': activeTab !== 'products'
                       }">
                        <h3 class="text-sm font-medium text-gray-500 dark:text-gray-300">Products Owned</h3>
                        <p class="text-xl font-bold"
                           :class="{
                               'text-yellow-800 dark:text-yellow-500': activeTab === 'products',
                               'text-gray-800 dark:text-white': activeTab !== 'products'
                           }">
                           {{ $products->total() }}
                        </p>
                    </a>
                    <a href="#sales" @click.prevent="changeTab('sales')"
                       class="p-4 rounded-lg shadow transition-all duration-300 cursor-pointer border stats-card"
                       :class="{
                           'bg-yellow-500 dark:bg-yellow-800 border-yellow-500': activeTab === 'sales',
                           'bg-white dark:bg-gray-700 border-gray-200 dark:border-gray-600 hover:bg-yellow-500 dark:hover:bg-yellow-800': activeTab !== 'sales'
                       }">
                        <h3 class="text-sm font-medium text-gray-500 dark:text-gray-300">Sales Made</h3>
                        <p class="text-xl font-bold"
                           :class="{
                               'text-yellow-800 dark:text-yellow-500': activeTab === 'sales',
                               'text-gray-800 dark:text-white': activeTab !== 'sales'
                           }">
                           {{ $sales->total() }}
                        </p>
                    </a>
                    <a href="#inputs" @click.prevent="changeTab('inputs')"
                       class="p-4 rounded-lg shadow transition-all duration-300 cursor-pointer border stats-card"
                       :class="{
                           'bg-yellow-500 dark:bg-yellow-800 border-yellow-500': activeTab === 'inputs',
                           'bg-white dark:bg-gray-700 border-gray-200 dark:border-gray-600 hover:bg-yellow-500 dark:hover:bg-yellow-800': activeTab !== 'inputs'
                       }">
                        <h3 class="text-sm font-medium text-gray-500 dark:text-gray-300">Stock Inputs</h3>
                        <p class="text-xl font-bold"
                           :class="{
                               'text-yellow-800 dark:text-yellow-500': activeTab === 'inputs',
                               'text-gray-800 dark:text-white': activeTab !== 'inputs'
                           }">
                           {{ $stockInputs->total() }}
                        </p>
                    </a>
                    <a href="#sent" @click.prevent="changeTab('sent')"
                       class="p-4 rounded-lg shadow transition-all duration-300 cursor-pointer border stats-card"
                       :class="{
                           'bg-yellow-500 dark:bg-yellow-800 border-yellow-500': activeTab === 'sent',
                           'bg-white dark:bg-gray-700 border-gray-200 dark:border-gray-600 hover:bg-yellow-500 dark:hover:bg-yellow-800': activeTab !== 'sent'
                       }">
                        <h3 class="text-sm font-medium text-gray-500 dark:text-gray-300">Stock Sent</h3>
                        <p class="text-xl font-bold"
                           :class="{
                               'text-yellow-800 dark:text-yellow-500': activeTab === 'sent',
                               'text-gray-800 dark:text-white': activeTab !== 'sent'
                           }">
                           {{ $stockOutputs->total() }}
                        </p>
                    </a>
                    <a href="#received" @click.prevent="changeTab('received')"
                       class="p-4 rounded-lg shadow transition-all duration-300 cursor-pointer border stats-card"
                       :class="{
                           'bg-yellow-500 dark:bg-yellow-800 border-yellow-500': activeTab === 'received',
                           'bg-white dark:bg-gray-700 border-gray-200 dark:border-gray-600 hover:bg-yellow-500 dark:hover:bg-yellow-800': activeTab !== 'received'
                       }">
                        <h3 class="text-sm font-medium text-gray-500 dark:text-gray-300">Stock Received</h3>
                        <p class="text-xl font-bold"
                           :class="{
                               'text-yellow-800 dark:text-yellow-500': activeTab === 'received',
                               'text-gray-800 dark:text-white': activeTab !== 'received'
                           }">
                           {{ $stockReceived->total() }}
                        </p>
                    </a>
                </div>

                <!-- Tab Navigation -->
                <div class="border-b border-gray-200 dark:border-gray-700 mb-6" x-data="tabs">
                    <nav class="-mb-px flex space-x-8 overflow-x-auto">
                        <button
                            @click="changeTab('products')"
                            :class="{
                                'border-yellow-500 text-yellow-600 dark:text-yellow-400': activeTab === 'products',
                                'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300': activeTab !== 'products'
                            }"
                            class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition-colors duration-200">
                            Products
                        </button>
                        <button
                            @click="changeTab('sales')"
                            :class="{
                                'border-yellow-500 text-yellow-600 dark:text-yellow-400': activeTab === 'sales',
                                'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300': activeTab !== 'sales'
                            }"
                            class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition-colors duration-200">
                            Sales
                        </button>
                        <button
                            @click="changeTab('inputs')"
                            :class="{
                                'border-yellow-500 text-yellow-600 dark:text-yellow-400': activeTab === 'inputs',
                                'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300': activeTab !== 'inputs'
                            }"
                            class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition-colors duration-200">
                            Stock Inputs
                        </button>
                        <button
                            @click="changeTab('sent')"
                            :class="{
                                'border-yellow-500 text-yellow-600 dark:text-yellow-400': activeTab === 'sent',
                                'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300': activeTab !== 'sent'
                            }"
                            class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition-colors duration-200">
                            Stock Sent
                        </button>
                        <button
                            @click="changeTab('received')"
                            :class="{
                                'border-yellow-500 text-yellow-600 dark:text-yellow-400': activeTab === 'received',
                                'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300 dark:text-gray-400 dark:hover:text-gray-300': activeTab !== 'received'
                            }"
                            class="whitespace-nowrap py-4 px-1 border-b-2 font-medium text-sm transition-colors duration-200">
                            Stock Received
                        </button>
                    </nav>
                </div>

                <!-- Tab Content -->
                <div x-data="tabs" x-cloak>
                    <!-- Products Tab -->
                    <div x-show="activeTab === 'products'" id="products" class="space-y-4">
                        <div class="overflow-x-auto rounded-lg border border-gray-200 dark:border-gray-700">
                            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                <thead class="bg-gray-50 dark:bg-gray-700">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Product Name
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Quantity
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Unit
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Input Price
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Selling Price
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                    @forelse($products as $product)
                                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                            {{ $product->name }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $product->quantity }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $product->unit }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ number_format($product->input_price_per_unit, 2) }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ number_format($product->selling_price_per_unit, 2) }}
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="px-6 py-4 text-center text-sm text-gray-500 dark:text-gray-300">
                                            No products found
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        {{ $products->links('vendor.pagination.tailwind') }}
                    </div>

                    <!-- Sales Tab -->
                    <div x-show="activeTab === 'sales'" id="sales" class="space-y-4">
                        <div class="overflow-x-auto rounded-lg border border-gray-200 dark:border-gray-700">
                            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                <thead class="bg-gray-50 dark:bg-gray-700">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Date
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Product
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Customer
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Quantity
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Total Price
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                    @forelse($sales as $sale)
                                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $sale->created_at->format('d/m/Y H:i') }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                            {{ $sale->product->name }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $sale->customer->username }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $sale->quantity }} {{ $sale->product->unit }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ number_format($sale->total_price, 2) }}
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="px-6 py-4 text-center text-sm text-gray-500 dark:text-gray-300">
                                            No sales found
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        {{ $sales->links('vendor.pagination.tailwind') }}
                    </div>

                    <!-- Stock Inputs Tab -->
                    <div x-show="activeTab === 'inputs'" id="inputs" class="space-y-4">
                        <div class="overflow-x-auto rounded-lg border border-gray-200 dark:border-gray-700">
                            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                <thead class="bg-gray-50 dark:bg-gray-700">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Date
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Product
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Quantity
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Input Price
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                    @forelse($stockInputs as $input)
                                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $input->created_at->format('d/m/Y H:i') }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                            {{ $input->product->name }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $input->quantity }} {{ $input->product->unit }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ number_format($input->input_price_per_unit, 2) }}
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="4" class="px-6 py-4 text-center text-sm text-gray-500 dark:text-gray-300">
                                            No stock inputs found
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        {{ $stockInputs->links('vendor.pagination.tailwind') }}
                    </div>

                    <!-- Stock Sent Tab -->
                    <div x-show="activeTab === 'sent'" id="sent" class="space-y-4">
                        <div class="overflow-x-auto rounded-lg border border-gray-200 dark:border-gray-700">
                            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                <thead class="bg-gray-50 dark:bg-gray-700">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Date
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Product
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            To
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Quantity
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Reason
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                    @forelse($stockOutputs as $output)
                                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $output->created_at->format('d/m/Y H:i') }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                            {{ $output->product->name }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $output->outputToUser->name }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $output->quantity }} {{ $output->product->unit }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $output->reason ?? 'N/A' }}
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="px-6 py-4 text-center text-sm text-gray-500 dark:text-gray-300">
                                            No stock transfers found
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        {{ $stockOutputs->links('vendor.pagination.tailwind') }}
                    </div>

                    <!-- Stock Received Tab -->
                    <div x-show="activeTab === 'received'" id="received" class="space-y-4">
                        <div class="overflow-x-auto rounded-lg border border-gray-200 dark:border-gray-700">
                            <table class="min-w-full divide-y divide-gray-200 dark:divide-gray-700">
                                <thead class="bg-gray-50 dark:bg-gray-700">
                                    <tr>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Date
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Product
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            From
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Quantity
                                        </th>
                                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 dark:text-gray-300 uppercase tracking-wider">
                                            Reason
                                        </th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                                    @forelse($stockReceived as $transfer)
                                    <tr class="hover:bg-gray-50 dark:hover:bg-gray-700">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $transfer->created_at->format('d/m/Y H:i') }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900 dark:text-white">
                                            {{ $transfer->product->name }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $transfer->outputByUser->name }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $transfer->quantity }} {{ $transfer->product->unit }}
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500 dark:text-gray-300">
                                            {{ $transfer->reason ?? 'N/A' }}
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="5" class="px-6 py-4 text-center text-sm text-gray-500 dark:text-gray-300">
                                            No received stock found
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        {{ $stockReceived->links('vendor.pagination.tailwind') }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('tabs', () => ({
                activeTab: 'products', // Default active tab

                init() {
                    // Check URL hash on initial load
                    this.checkHash();
                    
                    // Listen for hash changes
                    window.addEventListener('hashchange', () => this.checkHash());
                },

                checkHash() {
                    if(window.location.hash) {
                        const hash = window.location.hash.substring(1);
                        if(['products', 'sales', 'inputs', 'sent', 'received'].includes(hash)) {
                            this.activeTab = hash;
                            // Smooth scroll to the section
                            this.$nextTick(() => {
                                const element = document.getElementById(hash);
                                if (element) {
                                    element.scrollIntoView({ 
                                        behavior: 'smooth', 
                                        block: 'start',
                                        inline: 'nearest'
                                    });
                                }
                            });
                        }
                    }
                },

                changeTab(tab) {
                    this.activeTab = tab;
                    window.location.hash = tab;
                }
            }));
        });
    </script>
    <style>
        [x-cloak] { display: none !important; }
        
        .stats-card {
            transition: all 0.3s ease;
        }
        
        .stats-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        
        .stats-card.active {
            border-color: #ecc94b;
        }
    </style>
    @endpush
</x-app-layout>