<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('purchase_returns', function (Blueprint $table) {
            $table->id();
            // Unaweza kuhitaji kurejelea StockInput kama ndio source ya purchase
            // Lakini kwa sasa, bidhaa na kiasi kinatosha
            $table->foreignId('product_id')->constrained()->onDelete('cascade'); // Bidhaa iliyorejeshwa kwa supplier
            $table->integer('quantity'); // Idadi ya bidhaa zilizorejeshwa
            $table->decimal('refund_received_amount', 10, 2)->nullable(); // Kiasi kilichorejeshwa kutoka supplier
            $table->text('reason')->nullable(); // Sababu ya kurejeshwa
            $table->foreignId('returned_by_user_id')->constrained('users')->onDelete('cascade'); // Mtumiaji aliyerekodi urejesho
            $table->timestamp('return_date'); // Tarehe ya urejesho
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('purchase_returns');
    }
};