<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sale_returns', function (Blueprint $table) {
            $table->id();
            $table->foreignId('sale_id')->constrained()->onDelete('cascade'); // Marejeleo ya Sale husika
            $table->foreignId('product_id')->constrained()->onDelete('cascade'); // Bidhaa iliyorejeshwa
            $table->integer('quantity'); // Idadi ya bidhaa zilizorejeshwa
            $table->decimal('refund_amount', 10, 2); // Kiasi kilichorejeshwa kwa mteja
            $table->text('reason')->nullable(); // Sababu ya kurejeshwa
            $table->foreignId('returned_by_user_id')->constrained('users')->onDelete('cascade'); // Mtumiaji aliyerekodi urejesho
            $table->timestamp('return_date'); // Tarehe ya urejesho
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sale_returns');
    }
};