<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB; // Import the DB facade

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('expenses', function (Blueprint $table) {
            // This makes the 'description' column nullable
            $table->string('description')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // IMPORTANT: Before making the column NOT NULL,
        // update any existing NULL values to an empty string or a default.
        // This prevents the "Data truncated" error when reverting nullability.
        DB::table('expenses')
            ->whereNull('description')
            ->update(['description' => '']);

        Schema::table('expenses', function (Blueprint $table) {
            // Revert 'description' column back to NOT NULL.
            // Assuming it was originally a VARCHAR(255) and NOT NULL.
            $table->string('description', 255)->nullable(false)->change();
        });
    }
};
