<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('expenses', function (Blueprint $table) {
            // Badilisha column ya 'description' iwe nullable kwanza,
            // kisha ongeza 'category_name' na 'other_details'
            // Ama kama unataka 'description' ibaki kama ilivyokuwa na 'category_name' iwe tofauti,
            // basi ongeza tu hizi mbili mpya.
            // Kwa mfumo huu mpya, 'description' iliyopo inaweza kubaki au kuhamishwa kazi.
            // Nitaichukulia 'description' ya awali sasa inakuwa 'category_name' au 'other_details'.

            // Ondoa column ya 'description' kama unataka kubadilisha kazi yake kabisa.
            // $table->dropColumn('description');

            // Ongeza column mpya ya kuhifadhi jina la kategoria iliyochaguliwa
            $table->string('category_name')->after('user_id'); // Weka baada ya user_id
            // Ongeza column ya kuhifadhi maelezo ya ziada kwa 'Others'
            $table->string('other_details')->nullable()->after('category_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('expenses', function (Blueprint $table) {
            $table->dropColumn('other_details');
            $table->dropColumn('category_name');
            // $table->string('description'); // Rudisha column ya 'description' kama ulifuta
        });
    }
};