<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('salary_payments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Mtumiaji aliyelipwa mshahara
            $table->decimal('amount', 10, 2); // Kiasi cha mshahara kilicholipwa
            $table->date('payment_date'); // Tarehe malipo yalifanyika
            $table->string('payment_period')->nullable(); // Mwezi au kipindi cha mshahara (mfano: "Juni 2025")
            $table->timestamps(); // created_at na updated_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('salary_payments');
    }
};
