<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('expenses', function (Blueprint $table) {
            $table->id();
            $table->string('description'); // Maelezo ya matumizi
            $table->decimal('amount', 10, 2); // Kiasi cha matumizi, mfano 12345.67
            $table->date('expense_date'); // Tarehe matumizi yalifanyika
            $table->foreignId('user_id')->constrained()->onDelete('cascade'); // Mtumiaji aliyerekodi matumizi
            $table->timestamps(); // created_at na updated_at
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('expenses');
    }
};
