<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('monthly_sale_reports', function (Blueprint $table) {
    $table->id();
    $table->integer('month');
    $table->integer('year');
    $table->decimal('total_sales', 12, 2);
    $table->decimal('total_profit', 12, 2);
    $table->string('report_path')->nullable();
    $table->foreignId('closed_by')->constrained('users');
    $table->timestamp('closed_at');
    $table->timestamps();
});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('monthly_sale_reports');
    }
};
