<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    // In the migration file
public function up()
{
    Schema::table('products', function (Blueprint $table) {
        $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null');
    });
    
    Schema::create('stock_transfers', function (Blueprint $table) {
        $table->id();
        $table->foreignId('product_id')->constrained();
        $table->decimal('quantity', 10, 2);
        $table->foreignId('from_user_id')->constrained('users');
        $table->foreignId('to_user_id')->constrained('users');
        $table->timestamps();
    });
}

public function down()
{
    Schema::table('products', function (Blueprint $table) {
        $table->dropForeign(['user_id']);
        $table->dropColumn('user_id');
    });
    
    Schema::dropIfExists('stock_transfers');
}
};
